%{CPP_TEMPLATE}

#include "%{APPNAMELC}.h"
#include <tdeapplication.h>
#include <dcopclient.h>
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>

static const char description[] =
    I18N_NOOP("A TDE Application");

static const char version[] = "%{VERSION}";

static TDECmdLineOptions options[] =
{
    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
    TDECmdLineLastOption
};

int main(int argc, char **argv)
{
    TDEAboutData about("%{APPNAMELC}", I18N_NOOP("%{APPNAME}"), version, description,
                     TDEAboutData::License_%{LICENSE}, "(C) %{YEAR} %{AUTHOR}", 0, 0, "%{EMAIL}");
    about.addAuthor( "%{AUTHOR}", 0, "%{EMAIL}" );
    TDECmdLineArgs::init(argc, argv, &about);
    TDECmdLineArgs::addCmdLineOptions(options);
    TDEApplication app;

    // register ourselves as a dcop client
    app.dcopClient()->registerAs(app.name(), false);

    // see if we are starting with session management
    if (app.isRestored())
    {
        RESTORE(%{APPNAME});
    }
    else
    {
        // no session.. just start up normally
        TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();
        if (args->count() == 0)
        {
            %{APPNAME} *widget = new %{APPNAME};
            widget->show();
        }
        else
        {
            int i = 0;
            for (; i < args->count(); i++)
            {
                %{APPNAME} *widget = new %{APPNAME};
                widget->show();
                widget->load(args->url(i));
            }
        }
        args->clear();
    }

    return app.exec();
}
