/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef PIXMAPCOLLECTION_H
#define PIXMAPCOLLECTION_H

#include <tqstring.h>
#include <tqpixmap.h>
#include <tqvaluelist.h>
#include "designerappiface.h"

class TQMimeSourceFactory;
class Project;

class PixmapCollection
{
public:
    struct Pixmap
    {
	TQPixmap pix;
	TQString name;
	TQString absname;
	TQ_DUMMY_COMPARISON_OPERATOR( Pixmap )
    };

    PixmapCollection( Project *pro );
    ~PixmapCollection();

    bool addPixmap( const Pixmap &pix, bool force = TRUE );
    void removePixmap( const TQString &name );
    TQPixmap pixmap( const TQString &name );

    TQValueList<Pixmap> pixmaps() const;
    bool isEmpty() const;

    void setActive( bool b );

    void load( const TQString& filename );

    DesignerPixmapCollection *iFace();

private:
    TQString unifyName( const TQString &n );
    void savePixmap( Pixmap &pix );

    TQString imageDir() const;
    void mkdir();

private:
    TQValueList<Pixmap> pixList;
    TQMimeSourceFactory *mimeSourceFactory;
    Project *project;
    DesignerPixmapCollectionImpl *iface;

};

#endif
