/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel                                  *
 *   the_docter@gmx.net                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CONFIG_H
#define CONFIG_H

#include <tqdom.h>
#include <menulistviewitem.h>

#include "kommando.h"
#include "commandobutton.h"
#include "kommandoview.h"

class TQWidgetStack;

class KDE_EXPORT Config{
    public:
        static Config& getSingleton(){
            static Config instance;
            return instance;
        }

        ~Config();

        bool readConfigFile();
        bool writeConfigFile();
        void fromConfigDlg(KommandoViewList& listViews);
        void toListView(KommandoViewList& listViews, TQWidgetStack* listViewParent);
        void toKommandoMenu(Kommando* buttonParent);
        void setDefaultValues();

        void setShortcut(const TQString& cut){ mShortcut = cut; }
        TQString Shortcut() const{ return mShortcut; }

        void setTintColor(const TQColor& theValue){ mTintColor = theValue; }
        TQColor tintColor() const { return mTintColor; }

        void setOpacity(const float value){mOpacity=value;}
        float opacity() const {return mOpacity;}

        void setMenuButtonSize(unsigned short theValue){ mMenuButtonSize = theValue; }
        unsigned short menuButtonSize() const { return mMenuButtonSize; }

        void setNavButtonSize (unsigned short theValue){ mNavButtonSize = theValue; }
        unsigned short navButtonSize() const { return mNavButtonSize; }

        void setMenuRadius(unsigned int theValue){ mMenuRadius = theValue; }
        unsigned int menuSize() const { return mMenuRadius*2; }
        unsigned int menuRadius() const{ return mMenuRadius; }
        unsigned int buttonDistance() const { return (mMenuRadius-static_cast<int>(mMenuButtonSize*1.38)); }

        void setScheme(const TQString& theValue){ mScheme = theValue; }
        TQString scheme() const{ return mScheme; }

    protected:
        Config();
        Config(const Config&);
        void createDefaultConfigFile();
    
        TQString mConfigPath;
        TQString mShortcut;
        TQColor mTintColor;
        float mOpacity;
        TQString mScheme;
        unsigned short mMenuButtonSize;
        unsigned short mNavButtonSize;
        unsigned int mMenuRadius;
        bool mAddDefalutMenuLink;
        TQDomDocument* doc;

        //Factory functions
        Menu* menuFromXML(const TQDomElement& ownNode, Kommando* buttonParent, Menu* parent=NULL);
        CommandoButton* comButtonFromXML(const TQDomElement& ownNode, Kommando* parent);
        TQListView* newListView(TQWidget * parent, const char* name);

        void menuItemToXML(TQDomNode& parent, MenuListViewItem* item);

        //The following 3 methods could have been implemented in just 1 method, if there would be no need in overriding the parent argument
        //so I put the code both menuItemFromXML methods share in itemHelper to reduce redundancy
        void menuItemFromXML(KommandoView* parent,  TQListViewItem* after, const TQDomElement& ownNode);
        void menuItemFromXML(TQListViewItem* parent,  TQListViewItem* after, const TQDomElement& ownNode);
        void itemHelper(const TQDomElement& ownNode, MenuListViewItem* item);

        //Some factory functions that allow to setup a xml file quickly
        TQDomElement newNode(const TQString& nodename, TQDomNode& parent, int value);
        TQDomElement newNode(const TQString& nodename, TQDomNode& parent, float value);
        TQDomElement newNode(const TQString& nodename, TQDomNode& parent, const TQString& value);
        TQDomElement newNode(const TQString& nodename, TQDomNode& parent, const TQString& value, const TQString& attrname, const TQString& attrvalue);
        TQDomElement newButton(TQDomNode& parent, const TQString& icon, const TQString& command);
        TQDomElement newMenu(TQDomNode& parent, const TQString& appName = TQString::null, const TQString& icon = TQString::null);
};

#endif
