/***************************************************************************
                          stdtransactiondownloaded.cpp
                             -------------------
    begin                : Sun May 11 2008
    copyright            : (C) 2008 by Thomas Baumgart
    email                : Thomas Baumgart <ipwizard@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// ----------------------------------------------------------------------------
// QT Includes

// ----------------------------------------------------------------------------
// KDE Includes

#include <tdelocale.h>
#include <kdebug.h>

// ----------------------------------------------------------------------------
// Project Includes

#include <stdtransactiondownloaded.h>
#include <kmymoney/kmymoneyglobalsettings.h>
#include <kmymoney/register.h>

using namespace KMyMoneyRegister;
using namespace KMyMoneyTransactionForm;

StdTransactionDownloaded::StdTransactionDownloaded(Register *parent, const MyMoneyTransaction& transaction, const MyMoneySplit& split, int uniqueId) :
  StdTransaction(parent, transaction, split, uniqueId)
{
}

bool StdTransactionDownloaded::paintRegisterCellSetup(TQPainter* painter, int& row, int& col, TQRect& cellRect, TQRect& textRect, TQColorGroup& cg, TQBrush& brush)

{
  bool rc = Transaction::paintRegisterCellSetup(painter, row, col, cellRect, textRect, cg, brush);
  // if not selected paint in selected background color
  if(!isSelected()) {
    cg.setColor(TQColorGroup::Base, KMyMoneyGlobalSettings::importedTransactionColor());
    brush = TQBrush(cg.base());
  }
  return rc;
}

InvestTransactionDownloaded::InvestTransactionDownloaded(Register *parent, const MyMoneyTransaction& transaction, const MyMoneySplit& split, int uniqueId) :
    InvestTransaction(parent, transaction, split, uniqueId)
{
}

bool InvestTransactionDownloaded::paintRegisterCellSetup(TQPainter* painter, int& row, int& col, TQRect& cellRect, TQRect& textRect, TQColorGroup& cg, TQBrush& brush)

{
  bool rc = Transaction::paintRegisterCellSetup(painter, row, col, cellRect, textRect, cg, brush);
  // if not selected paint in selected background color
  if(!isSelected()) {
    cg.setColor(TQColorGroup::Base, KMyMoneyGlobalSettings::importedTransactionColor());
    brush = TQBrush(cg.base());
  }
  return rc;
}

