/***************************************************************************
                          kmymoneydateinput.h
                             -------------------
    copyright            : (C) 2000 by Michael Edwardes
    email                : mte@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMYMONEYDATEINPUT_H
#define KMYMONEYDATEINPUT_H

// ----------------------------------------------------------------------------
// QT Includes

#include <tqwidget.h>
#include <tqlineedit.h>
#include <tqdatetime.h>
#include <tqdatetimeedit.h>
#include <tqvbox.h>

// ----------------------------------------------------------------------------
// KDE Includes

#include <kdatepicker.h>
class KPushButton;
class KPassivePopup;

// ----------------------------------------------------------------------------
// Project Includes

// Ideas neatly taken from korganizer
// Respective authors are credited.
// Some ideas/code have been borrowed from Calendar-0.13 (phoenix.bmedesign.com/~qt)

/**
  * Provided to be able to catch the focusOut events before the contents gets changed
  */
class KMyMoneyDateEdit : public TQDateEdit
{
  TQ_OBJECT
  
public:
  KMyMoneyDateEdit(const TQDate& date, TQWidget *parent=0, const char *name=0) : TQDateEdit(date, parent, name) {}

protected:
  /** reimplemented for internal reasons */
  bool event(TQEvent* e);
};

/**
  * This class provides the general widget used for date selection
  * throughout the KMyMoney project. It provides an TQDateEdit widget
  * which is based on an edit field with spin boxes and adds a TQPushButton
  * to open a KDatePicker.
  */
class kMyMoneyDateInput : public TQHBox
{
  TQ_OBJECT
  

public:
  kMyMoneyDateInput(TQWidget *parent=0, const char *name=0, TQt::AlignmentFlags flags=TQt::AlignLeft);
  ~kMyMoneyDateInput();

  // Replace calls to this with the new date() method
  // TQDate getTQDate(void) KDE_DEPRECATED;

  TQDate date(void) const;
  void setDate(TQDate date);
  void loadDate(const TQDate& date);
  void resetDate(void);
  TQWidget* focusWidget(void) const;
  virtual void setRange(const TQDate & min, const TQDate & max) { dateEdit->setRange(min, max); }
  void markAsBadDate(bool bad = false, const TQColor& = TQColor());

public slots:
  virtual void show(void);

signals:
  void dateChanged(const TQDate& date);

protected:
  /**
    * - increments/decrements the date upon +/- key input
    * - increments/decrements the date upon Up/Down key input
    * - sets the date to current date when the 'T' key is pressed.
    *   The actual key for this to happen might be overridden through
    *   an i18n package. The 'T'-key is always possible.
    */
  void keyPressEvent(TQKeyEvent * k);
  void resizeEvent(TQResizeEvent*);

  /** To intercept events sent to focusWidget() */
  bool eventFilter(TQObject *o, TQEvent *e);

protected slots:
  void slotDateChosen(TQDate date);
  void toggleDatePicker();

private slots:
  void slotDateChosenRef(const TQDate& date);
  void fixSize(void);

private:
  TQDateEdit *dateEdit;
  KDatePicker *m_datePicker;
  TQDate m_date;  // The date !
  TQDate m_prevDate;
  TQt::AlignmentFlags m_qtalignment;
  TQVBox *m_dateFrame;
  KPushButton *m_dateButton;
  KPassivePopup *m_datePopup;
  int m_focusDatePart;
};

#endif

