/***************************************************************************
                         kguiutils.cpp  -  description
                            -------------------
   begin                : Fri Jan 27 2006
   copyright            : (C) 2006 Tony Bloomfield
   email                : Tony Bloomfield <tonybloom@users.sourceforge.net>
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// ----------------------------------------------------------------------------
// QT Includes
 // No need for TQDateEdit, TQSpinBox, etc., since these always return values

#include <tqcheckbox.h>
#include <tqlistbox.h>
#include <tqcombobox.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqwidget.h>
#include <tqhbox.h>
#include <tqspinbox.h>

// ----------------------------------------------------------------------------
// KDE Includes

// ----------------------------------------------------------------------------
// Project Includes

#include "kguiutils.h"
#include "../kmymoneyglobalsettings.h"

 /**************************************************************************
  *                                                                        *
  * The MandatoryFieldGroup code is courtesy of                            *
  * Mark Summerfield in TQt Quarterly                                       *
  * http://doc.trolltech.com/qq/qq11-mandatoryfields.html                  *
  *                                                                        *
  * Enhanced by Thomas Baumgart to support the lineedit field of a         *
  * a TQComboBox.                                                           *
  *                                                                        *
  **************************************************************************/

void kMandatoryFieldGroup::add(TQWidget *widget)
{
  if (!widgets.contains(widget)) {
    if (widget->inherits("TQCheckBox"))
      connect((TQCheckBox*)widget->tqt_cast("TQCheckBox"),
               TQT_SIGNAL(clicked()),
               this, TQT_SLOT(changed()));

    else if (widget->inherits("TQComboBox")) {
      TQComboBox* combo = (TQComboBox*)widget->tqt_cast("TQComboBox");
      TQLineEdit* lineedit = combo->lineEdit();
      if(lineedit) {
        connect(lineedit, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(changed()));
      } else {
        connect(combo, TQT_SIGNAL(highlighted(int)), this, TQT_SLOT(changed()));
      }
    }

    else if (widget->inherits("TQLineEdit"))
      connect((TQLineEdit*)widget->tqt_cast("TQLineEdit"),
               TQT_SIGNAL(textChanged(const TQString&)),
               this, TQT_SLOT(changed()));

    else if (widget->inherits("TQSpinBox"))
      connect((TQSpinBox*)widget->tqt_cast("TQSpinBox"),
               TQT_SIGNAL(valueChanged(const TQString&)),
                      this, TQT_SLOT(changed()));

    else if (widget->inherits("TQListBox"))
      connect((TQListBox*)widget->tqt_cast("TQListBox"),
               TQT_SIGNAL(selectionChanged()),
                      this, TQT_SLOT(changed()));

    else {
      tqWarning("MandatoryFieldGroup: unsupported class %s",
               widget->className());
      return;
    }

    widget->setPaletteBackgroundColor(KMyMoneyGlobalSettings::requiredFieldColor());
    widgets.append(widget);
    changed();
  }
}


void kMandatoryFieldGroup::remove(TQWidget *widget)
{
  widget->setPaletteBackgroundColor(widget->colorGroup().background());
  widgets.remove(widget);
  changed();
}


void kMandatoryFieldGroup::setOkButton(TQPushButton *button)
{
  if (okButton && okButton != button)
    okButton->setEnabled(true);
  okButton = button;
  changed();
}


void kMandatoryFieldGroup::changed(void)
{
  bool enable = true;
  TQValueList<TQWidget *>::ConstIterator i;
  for (i = widgets.begin(); i != widgets.end(); ++i) {
    TQWidget *widget = *i;
    // disabled widgets don't count
    if(!(widget->isEnabled())) {
      continue;
    }
    if (widget->inherits("TQCheckBox")) {
      if (((TQCheckBox*)widget->tqt_cast("TQCheckBox"))->state() == TQButton::NoChange) {
        enable = false;
        break;
      } else
        continue;
    }
    if (widget->inherits("TQComboBox")) {
      if (((TQComboBox*)widget->tqt_cast("TQComboBox"))->currentText().isEmpty()) {
        enable = false;
        break;
      } else
        continue;
    }
    if (widget->inherits("TQLineEdit")) {
      if (((TQLineEdit*)widget->tqt_cast("TQLineEdit"))->text().isEmpty()) {
        enable = false;
        break;
      } else
        continue;
    }
    if (widget->inherits("TQListBox")) {
      if (((TQListBox*)widget->tqt_cast("TQListBox"))->selectedItem() == 0) {
        enable = false;
        break;
      } else
        continue;
    }
  }

  if (okButton)
    okButton->setEnabled(enable);
  m_enabled = enable;

  emit stateChanged();
  emit stateChanged(enable);
}


void kMandatoryFieldGroup::clear(void)
{
  TQValueList<TQWidget *>::Iterator i;
  for (i = widgets.begin(); i != widgets.end(); ++i)
    (*i)->setPaletteBackgroundColor((*i)->colorGroup().background());
  widgets.clear();
  if (okButton) {
    okButton->setEnabled(true);
    okButton = 0;
    m_enabled = true;
  }
}


#include "kguiutils.moc"

