/***************************************************************************
                          kbudgetvalues  -  description
                             -------------------
    begin                : Wed Nov 28 2007
    copyright            : (C) 2007 by Thomas Baumgart
    email                : Thomas Baumgart <ipwizard@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBUDGETVALUES_H
#define KBUDGETVALUES_H

// ----------------------------------------------------------------------------
// QT Includes

#include <tqdatetime.h>
class TQLabel;

// ----------------------------------------------------------------------------
// KDE Includes

// ----------------------------------------------------------------------------
// Project Includes

#include <kmymoney/kbudgetvaluesdecl.h>
#include <kmymoney/mymoneybudget.h>
class kMyMoneyEdit;

/**
 * @author Thomas Baumgart <ipwizard@users.sourceforge.net>
 */
class KBudgetValues : public KBudgetValuesDecl
{
  TQ_OBJECT
  
  public:
    KBudgetValues(TQWidget* parent = 0, const char* name = 0);
    ~KBudgetValues();

    void setBudgetValues(const MyMoneyBudget& budget, const MyMoneyBudget::AccountGroup& budgetAccount);
    void budgetValues(const MyMoneyBudget& budget, MyMoneyBudget::AccountGroup& budgetAccount);
    void clear(void);

  private:
    void enableMonths(bool enabled);
    void fillMonthLabels(void);

  protected slots:
    void slotChangePeriod(int id);

    /**
     * This slot clears the value in the value widgets of the selected budget type.
     * Values of the other types are unaffected.
     */
    void slotClearAllValues(void);

    /**
     * Helper slot used to postpone sending the valuesChanged() signal.
     */
    void slotNeedUpdate(void);

    void slotUpdateClearButton(void);

  protected:
    bool eventFilter(TQObject* o, TQEvent* e);

  private:
    kMyMoneyEdit*   m_field[12];
    TQLabel*         m_label[12];
    TQWidget*        m_currentTab;
    TQDate           m_budgetDate;

  signals:
    void valuesChanged(void);
};

#endif
