/***************************************************************************
                          kqifprofileeditor.h  -  description
                             -------------------
    begin                : Tue Dec 24 2002
    copyright            : (C) 2002 by Thomas Baumgart
    email                : thb@net-bembel.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MYMONEYQIFPROFILEEDITOR_H
#define MYMONEYQIFPROFILEEDITOR_H

// ----------------------------------------------------------------------------
// QT Includes

#include <tqwidget.h>
#include <tqvalidator.h>
class TQListViewItem;

// ----------------------------------------------------------------------------
// KDE Includes

// ----------------------------------------------------------------------------
// Project Includes

#include "mymoneyqifprofileeditordecl.h"
#include "../converter/mymoneyqifprofile.h"

/**
  * @author Thomas Baumgart
  */

class MyMoneyQifProfileNameValidator : public TQValidator
{
  TQ_OBJECT
  

public:
  MyMoneyQifProfileNameValidator(TQObject *o, const char *name);
  virtual ~MyMoneyQifProfileNameValidator();

  TQValidator::State validate(TQString&, int&) const;
};


class MyMoneyQifProfileEditor : public MyMoneyQifProfileEditorDecl
{
  TQ_OBJECT
  

public:
  MyMoneyQifProfileEditor(const bool edit = false, TQWidget *parent=0, const char *name=0);
  virtual ~MyMoneyQifProfileEditor();

  /**
    * This method returns the currently selected profile in the list box.
    */
  const TQString selectedProfile() const;

public slots:
  void slotOk(void);

protected slots:
  void slotLoadProfileFromConfig(const TQString& name);
  void slotReset(void);
  void slotRename(void);
  void slotDelete(void);
  void slotNew(void);
  void slotAmountTypeSelected(TQListViewItem*);
  void slotDecimalChanged(const TQString& val);
  void slotThousandsChanged(const TQString& val);
  void slotHelp(void);

private:
  void loadProfileListFromConfig(void);
  void loadWidgets(void);
  void showProfile(void);
  void addProfile(const TQString& name);
  void deleteProfile(const TQString& name);
  const TQString enterName(bool& ok);

private:
  bool                m_inEdit;
  MyMoneyQifProfile   m_profile;
  bool                m_isDirty;
  bool                m_isAccepted;
  TQListViewItem*      m_selectedAmountType;
};

#endif
