/***************************************************************************
 *                                                                         *
 *   Copyright (C) 2005, 2006 by Kevin Gilbert                             *
 *   kev.gilbert@cdu.edu.au                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 ***************************************************************************/

#ifndef _KNMAP_H_
#define _KNMAP_H_

#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#include <ntqstringlist.h>
#include <tdemainwindow.h>
#include "global.h"

//	forward class definitions
//	=========================

class TDEAction;
class TDEToggleAction;
class MainWidget;
class ScanWidget;

//	Knmap class definition
//	======================

class Knmap : public TDEMainWindow
{	TQ_OBJECT

	public:
		Knmap( );

		static bool getDirPath( const TQString& caption, TQString& path );
		static void getDirPath( const TQString& caption, TQString& path, TQLineEdit* lineEdit );
		static bool getFilePath( const TQString& caption, TQString& path, const bool save );
		static void getFilePath( const TQString& caption, TQString& path, TQLineEdit* lineEdit, const bool save );

	private slots:
		void slotConfigureShortcuts( );
		void slotConfigureToolbars( );
		void slotSetCaption( const TQString& caption );
		void slotNewToolbarConfig( );
		void slotOutputAvailable( const bool saveState, const bool saveAsState );
		void slotSetManPageActionStuff( const bool useLocalManPage );
		void slotVisibleScanWidgetChanged( ScanWidget* scanWidget );

	private:
		void createMenu( );
		void findNmap( );
		bool queryExit( );
		void readSettings( );
		void saveSettings( );
		void switchManPages( );

		TDEAction*       m_fileSaveAction;
		TDEAction*       m_fileSaveAsAction;
		MainWidget*    m_mainWidget;
		TDEAction*       m_settingsManAction;
		TDEToggleAction* m_useTargetHostAction;
		TDEToggleAction* m_wrapTextAction;
};

#endif // _KNMAP_H_
