/***************************************************************************
 *   Copyright (C) 2007 by Rajko Albrecht  ral@alwins-world.de             *
 *   http://tdesvn.alwins-world.de/                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#ifndef _SVNTQT_TYPES_HPP
#define _SVNTQT_TYPES_HPP

#include "svnqt/svnqt_defines.h"
#include "svnqt/shared_pointer.h"

// qt
#include <tqglobal.h>

#include <tqstring.h>
#include <tqpair.h>
#include <tqvaluelist.h>
#include <tqmap.h>

namespace svn
{
    // forward declarations
    class AnnotateLine;
    class Context;
    class DirEntry;
    class InfoEntry;
    class LogEntry;
    class Revision;
    class Status;
    class Targets;
    class Path;
    class StringArray;

    typedef TQLIST<AnnotateLine> AnnotatedFile;

    typedef SharedPointer<DirEntry> DirEntryPtr;
    typedef TQLIST<DirEntryPtr> DirEntries;
    typedef TQLIST<InfoEntry> InfoEntries;
    /// simple list of log entries
    typedef TQLIST<LogEntry> LogEntries;
    /// shared_pointer for LogEntriesMap
    typedef SharedPointer<LogEntries> LogEntriesPtr;

    /// map of logentries - key is revision
    typedef TQMap<long,LogEntry> LogEntriesMap;
    /// shared_pointer for LogEntriesMap
    typedef SharedPointer<LogEntriesMap> LogEntriesMapPtr;

    typedef SharedPointer<Status> StatusPtr;
    typedef TQLIST<StatusPtr> StatusEntries;
    typedef TQLIST<Revision> Revisions;

    /** Range of Revision */
    typedef TQPair<Revision,Revision> RevisionRange;
    /** list of revision ranges */
    typedef TQLIST<RevisionRange> RevisionRanges;

    /// map of property names to values
    typedef TQMap<TQString,TQString> PropertiesMap;
    /// pair of path, PropertiesMap
    typedef TQPair<TQString, PropertiesMap> PathPropertiesMapEntry;
    /// vector of path, Properties pairs
    typedef TQLIST<PathPropertiesMapEntry> PathPropertiesMapList;
    /// shared pointer for properties
    typedef SharedPointer<PathPropertiesMapList> PathPropertiesMapListPtr;

    typedef TQLIST<Path> Pathes;

    //! Mapper enum for svn_depth_t
    /*!
     * Until subversion prior 1.5 is supported by this lib we must hide the svn_depth_t enum from interface.
     * \since subversion 1.5 / svnqt 1.0
     * \sa svn_depth_t
     */
    enum Depth {
        DepthUnknown,
        DepthExclude,
        DepthEmpty,
        DepthFiles,
        DepthImmediates,
        DepthInfinity
    };
}

#endif
