/***************************************************************************
 *   Copyright (C) 2005-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#ifndef SVNACTIONS_H
#define SVNACTIONS_H

#include "client.h"
#include "revision.h"
#include "smart_pointer.h"
#include "shared_pointer.h"
#include "svnqttypes.h"

#include "simple_logcb.h"

#include <kurl.h>
#include <kguiitem.h>

#include <tqobject.h>
#include <tqdatetime.h>
#include <tqstringlist.h>

class ItemDisplay;
class SvnItem;
class KDialog;
class KDialogBase;
class TQDialog;
class CContextListener;
class TDEProcess;
class SvnActionsData;
class CheckModifiedThread;
class CheckUpdatesThread;
class FillCacheThread;

namespace svn {
    class Context;
    class LogEntry;
    class InfoEntry;
}

namespace TDEIO {
    class Job;
}

/**
@author Rajko Albrecht
*/
class SvnActions : public TQObject,public SimpleLogCb
{
    TQ_OBJECT
  
public:
    enum ThreadType {
        checkupdatethread,
        fillcachethread,
        checkmodifiedthread
    };

    SvnActions(ItemDisplay *parent, const char *name = 0,bool processes_blocked=false);
    ~SvnActions();
    void reInitClient();
    //svn::Client&svnClient(){return m_Svnclient;}
    svn::Client* svnclient();
    void prepareUpdate(bool ask);
    template<class T> KDialogBase* createDialog(T**ptr,const TQString&_head,bool OkCance=false,
            const char*name="standard_dialog",
            bool showHelp=false,bool modal=true,
            const KGuiItem&u1 = KGuiItem());

    bool makeGet(const svn::Revision&start, const TQString&what,const TQString&target,
        const svn::Revision&peg=svn::Revision::UNDEFINED,TQWidget*dlgparent=0);


    bool addItems(const TQValueList<svn::Path> &items,svn::Depth depth=svn::DepthEmpty);
    bool addItems(const TQStringList&w,svn::Depth depth=svn::DepthEmpty);
    void checkAddItems(const TQString&path,bool print_error_box=true);

    bool makeDelete(const svn::Pathes&);
    bool makeDelete(const TQStringList&);
    void makeLock(const TQStringList&,const TQString&,bool);
    void makeUnlock(const TQStringList&,bool);

    bool makeStatus(const TQString&what, svn::StatusEntries&dlist, svn::Revision&where, bool rec=false,bool all=true);
    bool makeStatus(const TQString&what, svn::StatusEntries&dlist, svn::Revision&where, bool rec,bool all,bool display_ignored,bool updates=false);
    bool makeList(const TQString&url,svn::DirEntries&dlist,svn::Revision&where,bool rec=false);

    bool createModifiedCache(const TQString&base);
    bool checkModifiedCache(const TQString&path);
    bool checkConflictedCache(const TQString&path);
    bool checkReposLockCache(const TQString&path);
    bool checkReposLockCache(const TQString&path,svn::SharedPointer<svn::Status>&t);
    void addModifiedCache(const svn::StatusPtr&what);
    void deleteFromModifiedCache(const TQString&what);

    bool makeIgnoreEntry(SvnItem*which,bool unignore);
    bool isLockNeeded(SvnItem*which,const svn::Revision&where);
    TQString searchProperty(TQString&store, const TQString&property, const TQString&start,const svn::Revision&where,bool up=false);
    svn::PathPropertiesMapListPtr propList(const TQString&which,const svn::Revision&where,bool cacheOnly);

    bool changeProperties(const svn::PropertiesMap&setList,const TQValueList<TQString>&,const TQString&path);

    //! generate and displays a revision tree
    /*!
     * the parameter @a what must prepared, eg, if it comes from working copy
     * it must not contain a "file://" inside.
     * \param what item to display
     * \param rev Revision the item-path is available, intersting only when @a what is a repository item
     * \param startr startrevision for log
     * \param endr endrevision for log
     */
    void makeTree(const TQString&what,const svn::Revision&rev,
        const svn::Revision&startr=svn::Revision(1),
        const svn::Revision&endr=svn::Revision::HEAD);
    void makeLog(const svn::Revision&start,const svn::Revision&end,const svn::Revision&peg,SvnItem*k,bool list_files=false,int limit = 0);
    void makeLog(const svn::Revision&start,const svn::Revision&end,const svn::Revision&peg,const TQString&,bool list_files=false, int limit=0);
    svn::SharedPointer<svn::LogEntriesMap> getLog(const svn::Revision&start,const svn::Revision& end,const svn::Revision&peg,const TQString&,bool list_files, int limit,TQWidget*parent=0);
    virtual bool getSingleLog(svn::LogEntry&,const svn::Revision&,const TQString&,const svn::Revision&,TQString&root);

    void makeBlame(const svn::Revision&start, const svn::Revision&end, SvnItem*k);
    void makeBlame(const svn::Revision&start, const svn::Revision&end, const TQString&,TQWidget*parent=0,const svn::Revision&peg=svn::Revision::UNDEFINED,SimpleLogCb*_acb=0);
    void makeUpdate(const TQStringList&what,const svn::Revision&rev,bool recurse);
    bool makeSwitch(const TQString&rUrl,const TQString&tPath,const svn::Revision&r,svn::Depth depth,const svn::Revision&peg,bool stickydepth,bool ignore_externals,bool allow_unversioned);
    bool makeSwitch(const TQString&path,const TQString&what);
    bool makeRelocate(const TQString&fUrl,const TQString&tUrl,const TQString&path,bool rec = true);
    bool makeCheckout(const TQString&,const TQString&,const svn::Revision&,const svn::Revision&,svn::Depth,bool isExport,bool openit,bool ignore_externals,bool overwrite,TQWidget*p);
    void makeInfo(TQPtrList<SvnItem> lst,const svn::Revision&,const svn::Revision&,bool recursive = true);
    void makeInfo(const TQStringList&lst,const svn::Revision&,const svn::Revision&,bool recursive = true);
    bool makeCommit(const svn::Targets&);
    void CheckoutExport(const TQString&what,bool _exp,bool urlisTarget=false);

    TQString getInfo(TQPtrList<SvnItem> lst,const svn::Revision&rev,const svn::Revision&peg,bool recursive,bool all=true);
    TQString getInfo(const TQString&_what,const svn::Revision&rev,const svn::Revision&peg,bool recursive,bool all=true);

    TQString makeMkdir(const TQString&);
    bool makeMkdir(const TQStringList&,const TQString&);
    bool isLocalWorkingCopy(const KURL&url,TQString&_baseUri);
    bool createUpdateCache(const TQString&what);
    bool checkUpdateCache(const TQString&path)const;
    bool isUpdated(const TQString&path)const;
    bool getUpdated(const TQString&path,svn::SharedPointer<svn::Status>&d)const;
    void clearUpdateCache();
    void removeFromUpdateCache(const TQStringList&what,bool exact_only);
    void stopCheckModThread();
    void stopCheckUpdateThread();
    void startFillCache(const TQString&path);
    void stopFillCache();
    void stopMain();
    void killallThreads();

    bool checkUpdatesRunning();
    void getaddedItems(const TQString&path,svn::StatusEntries&target);

    bool makeCopy(const TQString&,const TQString&,const svn::Revision&rev);
    bool makeCopy(const KURL::List&,const TQString&,const svn::Revision&rev);

    bool makeMove(const TQString&,const TQString&,bool);
    bool makeMove(const KURL::List&,const TQString&,bool);

    virtual bool makeCleanup(const TQString&);

    bool get(const TQString&what,const TQString& to,const svn::Revision&rev,const svn::Revision&peg,TQWidget*p);
    bool singleInfo(const TQString&what,const svn::Revision&rev,svn::InfoEntry&target,const svn::Revision&_peg=svn::Revision::UNDEFINED);

    void setContextData(const TQString&,const TQString&);
    void clearContextData();
    TQString getContextData(const TQString&)const;

    bool threadRunning(ThreadType which);

    virtual void customEvent ( TQCustomEvent * e );

    bool doNetworking();

protected:
    svn::smart_pointer<SvnActionsData> m_Data;

    void CheckoutExport(bool _exp);
    void CheckoutExportCurrent(bool _exp);
    void makeAdd(bool rec);
    CheckModifiedThread*m_CThread,*m_UThread;
    FillCacheThread*m_FCThread;
    void makeDiffinternal(const TQString&,const svn::Revision&,const TQString&,const svn::Revision&,TQWidget*,const svn::Revision&peg=svn::Revision::UNDEFINED);
    void makeDiffExternal(const TQString&p1,const svn::Revision&start,const TQString&p2,const svn::Revision&end,const svn::Revision&_peg,bool isDir,TQWidget*p,bool rec=true);

public slots:
    virtual void dispDiff(const TQByteArray&);
    virtual void slotProperties();
    virtual void slotNotifyMessage(const TQString&);
    virtual void slotCommit();
    virtual void slotUpdateHeadRec();
    virtual void slotUpdateTo();
    virtual void slotAdd();
    virtual void slotAddRec();
    virtual void slotCheckoutCurrent();
    virtual void slotExportCurrent();
    virtual void slotCheckout();
    virtual void slotExport();
    virtual void slotRevert();
    virtual void slotRevertItems(const TQStringList&);
    virtual void slotSwitch();
    virtual void slotResolved(const TQString&);
    virtual void slotResolve(const TQString&);
    virtual void makeDiff(const TQString&,const svn::Revision&,const svn::Revision&,const svn::Revision&_peg,bool isDir);
    virtual void makeDiff(const TQString&,const svn::Revision&,const TQString&,const svn::Revision&);
    virtual void makeDiff(const TQString&,const svn::Revision&,const TQString&,const svn::Revision&,const svn::Revision&,bool,TQWidget*p);
    virtual void makeDiff(const TQString&,const svn::Revision&,const TQString&,const svn::Revision&,TQWidget*);
    virtual void makeNorecDiff(const TQString&,const svn::Revision&,const TQString&,const svn::Revision&,TQWidget*);
    virtual void slotImport(const TQString&,const TQString&,const TQString&,svn::Depth,bool noIgnore,bool noUnknown);
    virtual void slotMergeWcRevisions(const TQString&,const svn::Revision&,const svn::Revision&,bool,bool,bool,bool);
    virtual void slotMerge(const TQString&,const TQString&, const TQString&,
                            const svn::Revision&,const svn::Revision&,const svn::Revision&,
                            bool,bool,bool,bool);
    virtual void slotMergeExternal(const TQString&src1,const TQString&src2, const TQString&target,
                                    const svn::Revision&rev1,const svn::Revision&rev2,const svn::Revision&_peg,bool);
    virtual void slotExtraLogMsg(const TQString&);
    virtual void slotMakeCat(const svn::Revision&start, const TQString&what,const TQString&disp,const svn::Revision&peg,TQWidget*dlgparent);

    virtual void slotCancel(bool);

signals:
    void clientException(const TQString&);
    void sendNotify(const TQString&);
    void reinitItem(SvnItem*);
    void sigRefreshAll();
    void sigThreadsChanged();
    void sigRefreshCurrent(SvnItem*);
    void sigRefreshIcons(bool);
    void sigExtraLogMsg(const TQString&);
    void sigGotourl(const TQString&);
    void sigCacheStatus(TQ_LONG,TQ_LONG);

protected slots:
    virtual void wroteStdin(TDEProcess*);
    virtual void procClosed(TDEProcess*);
    virtual void checkModthread();
    virtual void checkUpdateThread();
    virtual void receivedStderr(TDEProcess*,char*,int);
};

#endif
