/***************************************************************************
 *   Copyright (C) 2006-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#ifndef _PWSTORAGE_H
#define _PWSTORAGE_H

#include <tqstring.h>
#include <tqobject.h>
#include <tqmutex.h>

class PwStorageData;

/**
    Access to wallet isn't threadsafe 'cause wallet has not to be called from within threads!
 */
class PwStorage:public TQObject
{
    TQ_OBJECT
  
protected:
    PwStorageData* mData;
public:
    bool getCertPw(const TQString&realm,TQString&pw);
    bool getLogin(const TQString&realm,TQString&user,TQString&pw);
    bool getCachedLogin(const TQString&realm,TQString&user,TQString&pw);
    bool setCertPw(const TQString&realm, const TQString&pw);
    bool setLogin(const TQString&realm,const TQString&user,const TQString&pw);
    bool setCachedLogin(const TQString&realm,const TQString&user,const TQString&pw);
    bool connectWallet();

    static PwStorage*self();

protected:
    PwStorage();
    virtual ~PwStorage();
};

#endif

