/***************************************************************************
 *   Copyright (C) 2003 by Ian Wadham and Marco Krger                     *
 *   ianw2@optusnet.com.au                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef KGRDIALOG_TQT_H
#define KGRDIALOG_TQT_H

// If portable version, use TQDialog and TQMessageBox.
// If KDE version, use KDialogBase and KMessageBox.

#ifdef KGR_PORTABLE
#include <tqdialog.h>
#define KGR_DIALOG TQDialog
#include <tqmessagebox.h>

#else
#include <tdelocale.h>
#include <kdialogbase.h>
#define KGR_DIALOG KDialogBase
#include <tdemessagebox.h>
#endif

#include <tqlayout.h>

#include <tqlistbox.h>
#include <tqscrollbar.h>
#include <tqlineedit.h>
#include <tqhbox.h>
#include <tqpushbutton.h>
#include <tqbuttongroup.h>
#include <tqradiobutton.h>
#ifdef QT3
#include <tqtextedit.h>
#else
#include <tqmultilineedit.h>
#endif

#include <tqptrlist.h>

/**
@author Ian Wadham and Marco Krger
*/

class KGrCanvas;
class KGrGame;
class KGrCollection;
class KGrThumbNail;

/******************************************************************************/
/*******************    DIALOG TO SELECT A GAME AND LEVEL   *******************/
/******************************************************************************/

class KGrSLDialog : public KGR_DIALOG	// KGR_PORTABLE sets TQDialog/KDialogBase
{
Q_OBJECT
  
public:
    KGrSLDialog (int action, int requestedLevel, int collnIndex,
			TQPtrList<KGrCollection> & gamesList, KGrGame * theGame,
			TQWidget * parent = 0, const char *name = 0);
    ~KGrSLDialog();

    int selectedLevel()	{return (number->value());}
    int selectedGame()	{return (slCollnIndex);}

private slots:
    void slSetCollections (int cIndex);
    void slColln (int i);
    void slAboutColln ();
    void slShowLevel (int i);
    void slUpdate (const TQString & text);
    void slPaintLevel ();
    void slotHelp ();				// Will replace KDE slotHelp().

private:
    int			slAction;
    TQPtrList<KGrCollection> collections;	// List of games.
    int			defaultLevel;
    int			defaultGame;
    int			slCollnIndex;
    KGrGame *		game;
    KGrCollection *	collection;
    TQWidget *		slParent;

    TQLabel *		collnL;
    TQListBox *		colln;
    TQLabel *		collnN;
    TQLabel *		collnD;
    TQPushButton *	collnA;

    TQLabel *		numberL;
    TQLineEdit *		display;
    TQScrollBar *	number;
    TQPushButton *	levelNH;
    TQLabel *		slName;
    KGrThumbNail *	thumbNail;

#ifdef KGR_PORTABLE
    TQPushButton *	OK;
    TQPushButton *	HELP;
    TQPushButton *	CANCEL;
#endif
};

/*******************************************************************************
*************** DIALOG BOX TO CREATE/EDIT A LEVEL NAME AND HINT ****************
*******************************************************************************/

class KGrNHDialog : public KGR_DIALOG	// KGR_PORTABLE sets TQDialog/KDialogBase
{
Q_OBJECT
  
public:
    KGrNHDialog (const TQString & levelName, const TQString & levelHint,
			TQWidget * parent = 0, const char * name = 0);
    ~KGrNHDialog();

    TQString	getName()	{return (nhName->text());}
    TQString	getHint()	{return (mle->text());}

private:
    TQLineEdit *	nhName;
#ifdef QT3
    TQTextEdit *	mle;
#else
    TQMultiLineEdit * mle;
#endif
};

/*******************************************************************************
***************** DIALOG TO CREATE OR EDIT A GAME (COLLECTION) *****************
*******************************************************************************/

class KGrECDialog : public KGR_DIALOG	// KGR_PORTABLE sets TQDialog/KDialogBase
{
Q_OBJECT
  
public:
    KGrECDialog (int action, int collnIndex,
			TQPtrList<KGrCollection> & gamesList,
			TQWidget *parent = 0, const char *name = 0);
    ~KGrECDialog();

    TQString	getName()	{return (ecName->text());}
    TQString	getPrefix()	{return (ecPrefix->text());}
    bool	isTrad()	{return (ecTradB->isChecked());}
    TQString	getAboutText()	{return (mle->text());}

private slots:
    void ecSetRules (const char settings);
    void ecSetKGr();	// Radio button slots.
    void ecSetTrad();

private:
    TQPtrList<KGrCollection> collections;	// List of existing games.
    int			defaultGame;

    TQLabel *		nameL;
    TQLineEdit *		ecName;
    TQLabel *		prefixL;
    TQLineEdit *		ecPrefix;
    TQButtonGroup *	ecGrp;
    TQRadioButton *	ecKGrB;
    TQRadioButton *	ecTradB;
    TQLabel *		nLevL;

    TQLabel *		mleL;
#ifdef QT3
    TQTextEdit *		mle;
#else
    TQMultiLineEdit *	mle;
#endif

#ifdef KGR_PORTABLE
    TQPushButton *	OK;
    TQPushButton *	CANCEL;
#endif
};

/*******************************************************************************
***************  DIALOG TO SELECT A SAVED GAME TO BE RE-LOADED  ****************
*******************************************************************************/

#include <tqfile.h>
#include <tqtextstream.h>

class KGrLGDialog : public KGR_DIALOG	// KGR_PORTABLE sets TQDialog/KDialogBase
{
Q_OBJECT
  
public:
    KGrLGDialog (TQFile * savedGames, TQPtrList<KGrCollection> & collections,
			TQWidget * parent, const char * name);
    TQString getCurrentText() {return (lgList->currentText());}

private slots:
    void lgSelect (int n);

private:
    TQListBox * lgList;
    int lgHighlight;
};

/*******************************************************************************
******************  PORTABLE MESSAGE FUNCTIONS (TQt Version)  *******************
*******************************************************************************/

class KGrMessage : public TQDialog
{
public:
    static void information (TQWidget * parent, const TQString &caption, const TQString &text);
    static int warning (TQWidget * parent, TQString caption, TQString text,
			TQString label0, TQString label1, TQString label2 = "");
    static void wrapped (TQWidget * parent, TQString caption, TQString text);
};

#endif
