/***************************************************************************
 *   Copyright (C) 2003 by Sylvain Joyeux                                  *
 *   sylvain.joyeux@m4x.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef DPKG_H
#define DPKG_H

#include <config.h>

#include "packagemanager.h"
#include <kprocio.h>

/**
@author Sylvain Joyeux
*/
class Dpkg : public PackageManager
{
  Q_OBJECT
  

  typedef void (Dpkg::*ReceiveMethod) (const TQStringList& lines);
  ReceiveMethod m_receive;

  KProcIO m_process;
  TQString m_buffer;

private slots:
  void readReady(KProcIO* io);

private:
  void receiveSearch(const TQStringList& line);
  void receiveList(const TQStringList& line);

public:
  Dpkg(TQObject *parent = 0, const char *name = 0);
  ~Dpkg();

  virtual bool list(const TQString& package);
  virtual bool search(const TQString& file);

  virtual int capabilities(int query) const;

  virtual TQString getOnlineForm();
};

#endif
