/***************************************************************************
*   Copyright (C) 2005 by Alexander Nemish  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#ifndef BOOKMARKSDLG_H
#define BOOKMARKSDLG_H

#include <tqvariant.h>
#include <tqdialog.h>
#include <algorithm>
#include "bookmark.h"

class TQVBoxLayout;
class TQHBoxLayout;
class TQGridLayout;
class TQSpacerItem;
class TQTable;
class TQPushButton;

class BookmarksDlg : public TQDialog
{
	Q_OBJECT
  

public:
	BookmarksDlg(const Bookmarks& bms, TQWidget* parent = 0,
	             const char* name = 0, bool modal = FALSE, WFlags fl = 0);
	~BookmarksDlg();

	const Bookmarks& bookmarks() const { return m_bookmarks; }

	TQTable* bookmarksTable;
	TQPushButton* addButton;
	TQPushButton* deleteButton;
	TQPushButton* buttonHelp;
	TQPushButton* buttonOk;
	TQPushButton* buttonCancel;

protected:
	TQVBoxLayout* BookmarksDlgLayout;
	TQHBoxLayout* layout3;
	TQVBoxLayout* layout2;
	TQSpacerItem* Horizontal_Spacing2_2;
	TQHBoxLayout* Layout1;
	TQSpacerItem* Horizontal_Spacing2;

protected slots:
	virtual void languageChange();
	void addBookmark();
	void deleteBookmark();
	void valueChanged(int row, int col);
	void updateBookmarks();
private:
	Bookmarks m_bookmarks;
};

#endif // BOOKMARKSDLG_H
