//
// C++ Interface: k9videocodecs
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef K9VIDEOCODECS_H
#define K9VIDEOCODECS_H

#include "k9common.h"
#include <tqobject.h>
#include <tqmap.h>
#include "k9config.h"

/**
	@author Jean-Michel PETIT <k9copy@free.fr>
*/
class _k9VideoCodec;

class k9VideoCodecs : public TQObject
{
Q_OBJECT
  
public:
    k9VideoCodecs(TQObject *parent = 0, const char *name = 0);

    ~k9VideoCodecs();
    void save();
    void setFourcc(int _num,TQString _value);
    void setOptions0(int _num,TQString _value);
    void setOptions1(int _num,TQString _value);
    void setOptions2(int _num,TQString _value);
    void setCodecName(int _num,TQString _value);
    void remove(int _num);
    TQString getFourcc(int _num);
    TQString getOptions0(int _num);
    TQString getOptions1(int _num);
    TQString getOptions2(int _num);
    TQString getCodecName(int _num);

    int count();
    void reset();
private:
    TQMap <int,_k9VideoCodec> m_codecs;
    k9Config *m_config;


};

#endif
