//
// C++ Interface: k9mp4enc
//
// Description:
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef K9MP4ENC_H
#define K9MP4ENC_H
#include "k9common.h"
#include "k9dvdtitle.h"

#include <tqobject.h>
#include <k9process.h>
#include <tqtimer.h>
#include <tqstringlist.h>
class k9MP4Dlg;
/**
	@author Jean-Michel PETIT <k9copy@free.fr>
*/
class k9MP4Enc : public TQObject {
    Q_OBJECT
  
private:
    k9Process *m_process;
    k9MP4Dlg  *m_progress;
    k9DVDTitle *m_title;
    int getBitRate(k9DVDTitle *_title);
    TQString m_txt;
    TQString m_device;
    TQString m_filename;
    TQString m_height;
    TQString m_width;
    TQString m_size;
    TQString m_audioBitrate;
    TQString m_videoBitrate;
    TQString m_audioGain;
    TQString m_fourcc;
    TQString m_stderr;
    int m_parts;
    float m_percent;
    TQTimer *timer;
    TQString m_remain;
    uint32_t m_totalSize;
    bool m_2pass;
    int m_pass;
    bool m_canceled;
    int m_codec;
    int m_audioCodec;
    bool m_usecache;
    bool m_mpeg2;
    bool m_mpegChapters;
        
    TQStringList m_lstVideo,m_lstAudio,m_lstCodecs;
    int m_cpt;
    TQTime *time,m_timer3;
    TQString replaceParams(TQString _input);
    TQString round16(TQString _wh);
    TQString getChapterList(k9DVDTitle *_title);
    int getselectedSubp(k9DVDTitle *_title);

private slots:
    void getStdout(TDEProcess *proc, char *buffer, int buflen);
    void getStderr(TDEProcess *proc, char *buffer, int buflen);
    void timerDone();
    void slotCancel();

public:
    k9MP4Enc(TQObject *parent = 0, const char *name = 0,const TQStringList& args=0);
    ~k9MP4Enc();

    virtual void execute(k9DVDTitle *_title );

    virtual void setNumberCD(const TQString & _value) {
	m_parts = _value.toInt();
	if (m_parts==0) m_parts=1;
    }

    virtual void setDevice(const TQString& _value) {
        m_device = _value.stripWhiteSpace();
    };
    virtual void setFilename(const TQString& _value) {
        m_filename = _value.stripWhiteSpace();
    };
    virtual void setHeight(const TQString& _value) {
        m_height = _value.stripWhiteSpace();
    };
    virtual void setWidth(const TQString& _value) {
        m_width = _value.stripWhiteSpace();
    };
    virtual void setSize(const TQString& _value) {
        m_size = _value.stripWhiteSpace();
    };
    virtual void setAudioBitrate(const TQString& _value) {
        m_audioBitrate = _value.stripWhiteSpace();
    };
    virtual void setVideoBitrate(const TQString& _value) {
        m_videoBitrate = _value.stripWhiteSpace();
    };
    virtual void setAudioGain(const TQString& _value) {
	m_audioGain = _value.stripWhiteSpace();
    };
    virtual void setfourcc(const TQString& _value) {
        m_fourcc = _value.stripWhiteSpace();
    };

    virtual void set2Passes(bool _value) {
    	m_2pass=_value;
    }

    virtual void setUseCache(bool _value) {
    	m_usecache=_value;
    }

    virtual void setMpeg2(bool _value) {
	m_mpeg2=_value;
    }
    
    virtual void setCodec(const int& _value) {m_codec = _value;};

    virtual void setAudioCodec(const int& _value) {m_audioCodec = _value;};
	
    virtual TQWidget *getDialog() {return (TQWidget*)m_progress;};

    virtual bool isCanceled();
};

#endif
