/***************************************************************************
 *   Copyright (C) 2005 by Bastian Holst                                   *
 *   bastianholst@gmx.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef AMAROKCATALOG_H
#define AMAROKCATALOG_H

#include <katapultcatalog.h>
#include <kgenericfactory.h>
#include <tdeconfigbase.h>
#include "song.h"

class TQWidget;
class TQString;

/** 
@author Bastian Holst
*/
class AmarokCatalog : public KatapultCatalog
{
	Q_OBJECT
  
public:
	AmarokCatalog(TQObject*, const char*, const TQStringList&);
	virtual ~AmarokCatalog();
	
	unsigned int minQueryLen() const;
	void readSettings(TDEConfigBase *);
	void writeSettings(TDEConfigBase *);
	TQWidget * configure();
	//virtual void initialize();
	
public slots:
	void minQueryLenChanged(int);
	
protected:
	void queryChanged();
	void reset();
	void checkCollectionType();	
	
private:
	unsigned int _minQueryLen;
	bool _dynamicCollection;
	bool _gotCollectionStatus;	
	Song _result;
};

#endif //AMAROkCATALOG_H
