/***************************************************************************
 *   Copyright (C) 2005 by Joe Ferris                                      *
 *   jferris@optimistictech.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef MATCH_H
#define MATCH_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdemacros.h>

class KatapultItem;

/**
@author Joe Ferris
*/
class KDE_EXPORT Match  {
public:
	Match();
	Match(const KatapultItem *, int, unsigned int);
	
	int rank() const;
	const KatapultItem * item() const;
	bool isNull() const;
	unsigned int matched() const;

private:
	bool _null;
	int _rank;
	unsigned int _matched;
	const KatapultItem *_item;

};

#endif
