/***************************************************************************
 * $Id: running.ui.h,v 1.10 2008/07/31 19:56:26 hoganrobert Exp $
 *   Copyright (C) 2006 - 2008 Robert Hogan                                *
 *   robert@roberthogan.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.              *
 ***************************************************************************/

#include <tqtooltip.h>
#include <tqpopupmenu.h>

#include <tdelocale.h>
#include <kdebug.h>

//dummy
#include "torkconfig.h"


void Running::init()
{

    TQStringList existingMaps = TorkConfig::sOCKSBindAddressMany();
    TQListViewItem *tm;
	for ( TQStringList::Iterator it = existingMaps.begin(); it != existingMaps.end(); ++it )
	{
		if ((*it).isEmpty())
			continue;
        TQString entry = (*it).section(":",0,0);
        TQString port = (*it).section(":",1,1);

        tm = new TQListViewItem(SOCKSBindAddressMany,entry,port);
    }

    TQStringList existingSocksPolicies = TorkConfig::sOCKSPolicy();

	for ( TQStringList::Iterator it = existingSocksPolicies.begin(); it != existingSocksPolicies.end(); ++it )
	{
		if ((*it).isEmpty())
			continue;
        TQString policy = (*it).section(" ",0,0);
        TQString section2 = (*it).section(" ",1,1);
        TQString entry = section2.section(":",0,0);
        TQString port = section2.section(":",1,1);


        tm = new TQListViewItem(SOCKSPolicy,policy,entry,port);
    }

    
}
void Running::PushAdd_clicked()
{
    new TQListViewItem(SOCKSBindAddressMany,Address->text(), Port->text());
}

void Running::PushAdd2_clicked()
{
    new TQListViewItem(SOCKSPolicy,Policy->currentText(),SocksAddress->text(), SocksPort->text());
}


void Running::SOCKSBindAddressMany_contextMenuRequested( TQListViewItem *, const TQPoint &point, int )
{

    TQPopupMenu *menu = new TQPopupMenu( SOCKSBindAddressMany );

    menu->clear();
    menu->insertItem( "Delete Entry", this,TQ_SLOT(slotDeleteEntry()) );
    menu->popup( point );

}


void Running::slotDeleteEntry( )
{

    TQListViewItemIterator it(SOCKSBindAddressMany, TQListViewItemIterator::Selected);
    while ( it.current() ) {
        if (SOCKSBindAddressMany->isSelected( it.current()))
            delete it.current();
        ++it;
    }

}


void Running::SOCKSPolicy_contextMenuRequested( TQListViewItem *, const TQPoint &point, int )
{

    TQPopupMenu *menu = new TQPopupMenu( SOCKSPolicy );

    menu->clear();
    menu->insertItem( "Delete Entry", this,TQ_SLOT(slotDeletePolicyEntry()) );
    menu->popup( point );

}


void Running::slotDeletePolicyEntry( )
{

    TQListViewItemIterator it(SOCKSPolicy, TQListViewItemIterator::Selected);
    while ( it.current() ) {
        if (SOCKSPolicy->isSelected( it.current()))
            delete it.current();
        ++it;
    }


}


void Running::kcfg_DefaultRunningNormalOptions_toggled( bool state)
{
    NormalOptions->setEnabled(!state);
}



void Running::kcfg_CookieAuthentication_toggled( bool )
{
    if ( kcfg_CookieAuthentication->isChecked()){
        kcfg_HashedControlPassword->setEnabled(false);
    }else{
        kcfg_HashedControlPassword->setEnabled(true);
    }
}


void Running::kcfg_HashedControlPassword_textChanged( const TQString & )
{
    if (! kcfg_HashedControlPassword->text().isEmpty()){
        kcfg_CookieAuthentication->setEnabled(false);
    }else{
        kcfg_CookieAuthentication->setEnabled(true);
    }

}

