/****************************************************************************
 ** $Id: torclient.h,v 1.76 2009/01/17 15:49:08 hoganrobert Exp $
 *   Copyright (C) 2006 - 2008 Robert Hogan                                *
 *   robert@roberthogan.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.              *
 ***************************************************************************
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for TQt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#ifndef _TORCLIENT_H_
#define _TORCLIENT_H_

#include <tqsocket.h>
#include <tqtextstream.h>
#include <tqlistview.h>

#include <kdebug.h>
#include <tdeconfigskeleton.h>

#include "torkconfig.h"


class TDEConfigSkeleton;
class TDEConfigSkeletonItem;

class PrevConfig
    {
    public:
        PrevConfig(): pr(0) {}
        PrevConfig( const TQString& name, const TQVariant& property )
            : nm(name), pr(property)
        {}
        typedef TQValueList<PrevConfig> PrevConfigList;
        TQString name() const { return nm; }
        TQVariant property() const { return pr; }
        void setName( TQString n ) { nm = n; }
        void setProperty( TQVariant p ) { pr = p; }
    private:
        TQString nm;
        TQVariant pr;
    };



class TorClient : public TQObject
{
    TQ_OBJECT
public:
    TorClient( const TQString &host, TQ_UINT16 port );

    virtual ~TorClient();


    void sendToServer(const TQString &string)
    {
        if (!socket)
            return;
        TQTextStream os(socket);
        os << string << "\r\n";
    }

    TQStringList currentServerReport()
    {
        return serverReport;
    }

    TQStringList currentClientReport()
    {
        return clientReport;
    }

    void bandwidth();
    bool isControllerWorking( );
    void updatePrevConfig(PrevConfig::PrevConfigList previtems);
    void newIdentity();
    void createService(const TQString &dir, const TQString &port);
    void setBandwidth(const TQString &rate, const TQString &burst, const TQString &max);
    void setGeoIPAvailable(bool set){geoip_db = set;};
    unsigned long int getCurBandwidthRate(){return m_CurBandwidthRate;};
    unsigned long int getCurBandwidthBurst(){return m_CurBandwidthBurst;};
    unsigned long int getCurMaxAdvertisedBandwidth()
                       {return m_CurMaxAdvertisedBandwidth;};
    void getBandwidth();
    void enableDNS( bool set );
    void enableTransPort( bool set );
    void cleanUp();

signals:

    void streamStatusUpdate(const TQString &, const TQString &,
        const TQString &, const TQString &, const TQString &);
    void ORStatusUpdate(const TQString &, const TQString &);
    void guardStatusUpdate(const TQString &, const TQString &);
    void circuitStatusUpdate(const TQString &, const TQString &,
                             const TQString &, const TQString &);
    void infoUpdate(const TQString &,const TQString &, const TQString &);
    void bwUpdate(const TQString &,const TQString &);
    void updateActiveServers(const TQStringList &);
    void updateServerStatus(const TQString &, const TQString &,
                            const TQString &,const TQString &);
    void fatalError();
    void serverError();
    void displayError(const TQString &,const TQString &);
    void displayServer(const TQString &,const TQString &);
    void whatImDoing(const TQString &);
    void copyOldConfig();
    void shouldIApplySettings();
    void torConnectionClosed();
    void makeTorkStoppable();
    void warnNoServerInfo();
    void needAlphaVersion( );
    void connectedToTor( );
    void authenticated();
    void streamBwUpdate(const TQString &,const TQString &,const TQString & );
    void setTorCaption(const TQString &);
    void processWarning(const TQString &,const TQString &);
    void processQuestion(const TQString &,const TQString &);
    void showServerBW(const TQString&);
    void updateTrayIcon(const TQString&);
    void resolvedAddress(const TQString&);
	void authenticationFailed();

public slots:
    void socketReadyRead();
    void applySettingsToRunningTor();
    void attemptAttach(const TQString &, const TQString &);
    void attemptExtendCircuit(const TQString &, const TQString &, bool);
    void attemptCreateCircuit(const TQString &, bool);
    void attemptCloseStream(const TQString &);
    void attemptAttachStreams( bool );
    void attemptCloseCircuit(const TQString &);
    void fetchServerInfo(const TQString &);
    void fetchServerInfoByNick(const TQString &);
    void slotCheckTorNet();
    void authenticate();
    void slotCheckGuards();
    void updateExcludeNodes();
    void updateEntryNodes();
    void updateExitNodes();
    void safeLogging( bool safe);
    void clearNodes();
    void strictExitNodes( bool strict );
    void configureServer( int orPort, int dirPort);
    void closeAllCircuits( TQListView* &circuitList);
    void allowPlainTextPorts( );
    void assignPortToRemove();
    void resolveAddress(const TQString &);
    void terminateTor();

private slots:
    void closeConnection()
    {
        socket->close();
        if ( socket->state() == TQSocket::Closing ) {
            // We have a delayed close.
            connect( socket, TQ_SIGNAL(delayedCloseFinished()),
                    TQ_SLOT(socketClosed()) );
        } else {
            // The socket is closed.
            socketClosed();
        }
    }


    void socketConnected()
    {
       emit connectedToTor();
    }

    void socketConnectionClosed()
    {
        emit torConnectionClosed();
    }

    void socketClosed()
    {
    }

    void socketError( int e )
    {
         if ( e == TQSocket::ErrHostNotFound ||
              e == TQSocket::ErrConnectionRefused )
            emit fatalError();
    }

    void parseEvent(const TQString &type, const TQString &info);
    void parseStream(const TQString &info);
    void parseGuards(const TQString &info);
    void parseORConn(const TQString &info);
    void parseServer(const TQString &info);
    void parseCircuit(const TQString &info);
    void parseInfo(const TQString &type, const TQString &info);
    void parseBW(const TQString &info);
    void parseAddrmap(const TQString &info);
    void parseStreamBW(const TQString &info);
    void parseDirStatus(const TQString &info);
    void parseStatusGeneral(const TQString &info);
    void resetClientReport();
    void updateCandidateServers(const TQString &path);
    void handle250(const TQString &line);
    void updateServerReport(const TQString &message,
                            const TQString &info);
    void updateClientReport(const TQString &message);
    void populateMessageFromStatusDetail(const TQString &line,
                                         TQString &message);
    void handleTorVersion( const TQString &caption);
    void readRouters();

private:
    TQSocket *socket;
    bool m_expectingCircuitInfo;
    bool m_expectingStreamInfo;
    bool m_expectingOrconnInfo;
    bool m_expectingGuardsInfo;
    bool m_expectingDirStatus;
    bool m_expectingServerInfo;
    bool m_resolvingServerAddress;
    bool geoip_db;
    TQString m_currentTorVersion;
    bool elementShouldBeUsed(const TDEConfigSkeletonItem* it);
    bool noSpecialProcessing(const TDEConfigSkeletonItem* it);
    bool readCookie();
    TQString ds_identity;
    TQString ds_fp_identity;
    TQString ds_ip;
    TQString ds_server;
    TQString ds_date;
    TQString ds_statuses;
    TQString m_statustip;
    TQString m_statustiptmp;
    bool m_controllerWorking;
    bool authorityread;
    bool m_firstloadcomplete;
    bool m_firstdircomplete;
    PrevConfig::PrevConfigList m_previtems;
    int m_CurBandwidthRate;
    int m_CurBandwidthBurst;
    int m_CurMaxAdvertisedBandwidth;
    TQString m_statustipIP;
    typedef TQMap<TQString, TQString> statusmap;
    statusmap statusMessage;
    statusmap serverStatus;
    statusmap serverStatusIcon;
    statusmap clientStatus;
    statusmap portMessage;
    statusmap clientStatusIcon;
    TQStringList serverReport;
    TQStringList clientReport;
    TQStringList m_WarnedPorts;
    TQStringList m_portsToReject;
    TQString m_portToRemove;
    TQStringList logResolveList;
};

#endif //


