/***************************************************************************
    copyright            : (C) 2001-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#include "richtextlabel.h"

#include <kdebug.h>

#include <tqlayout.h>

using Tellico::GUI::RichTextLabel;

RichTextLabel::RichTextLabel(TQWidget* parent) : TQTextEdit(parent) {
  init();
}

RichTextLabel::RichTextLabel(const TQString& text, TQWidget* parent) : TQTextEdit(text, TQString(), parent) {
  init();
}

TQSize RichTextLabel::sizeHint() const {
  return minimumSizeHint();
}

void RichTextLabel::init() {
  setReadOnly(true);
  setTextFormat(TQt::RichText);

  setFrameShape(TQFrame::NoFrame);
  viewport()->setMouseTracking(false);

  setPaper(colorGroup().background());

  setSizePolicy(TQSizePolicy(TQSizePolicy::Preferred, TQSizePolicy::Expanding));
  viewport()->setSizePolicy(TQSizePolicy(TQSizePolicy::Preferred, TQSizePolicy::Expanding));
}

#include "richtextlabel.moc"
