/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef ALEXANDRIAEXPORTER_H
#define ALEXANDRIAEXPORTER_H

class TQDir;

#include "exporter.h"

namespace Tellico {
  namespace Data {
    class Entry;
  }
  namespace Export {

/**
 * @author Robby Stephenson
 */
class AlexandriaExporter : public Exporter {
TQ_OBJECT
  

public:
  AlexandriaExporter() : Exporter() {}

  virtual bool exec();
  virtual TQString formatString() const;
  virtual TQString fileFilter() const { return TQString(); } // no need for this

  // no config options
  virtual TQWidget* widget(TQWidget*, const char*) { return 0; }

private:
  static TQString& escapeText(TQString& str);

  bool writeFile(const TQDir& dir, Data::ConstEntryPtr entry);
};

  } // end namespace
} // end namespace
#endif
