/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_UTILS_H
#define TELLICO_UTILS_H

#include <tqnamespace.h>

class KLibrary;

class TQColor;
class TQColorGroup;
class TQCursor;
class TQString;
class TQStringList;
class TQScrollView;

/**
 * This file contains utility functions.
 *
 * @author Robby Stephenson
 */
namespace Tellico {
  /**
   * Decode HTML entities. Only numeric entities are handled currently.
   */
  TQString decodeHTML(TQString text);
  /**
   * Return a random, and almost certainly unique UID.
   *
   * @param length The UID starts with "Tellico" and adds enough letters to be @p length long.
   */
  TQString uid(int length=20, bool prefix=true);
  uint toUInt(const TQString& string, bool* ok);
  /**
   * Replace all occurrences  of <i18n>text</i18n> with i18n("text")
   */
  TQString i18nReplace(TQString text);
  /**
   * Returns a list of the subdirectories in @param dir
   * Symbolic links are ignored
   */
  TQStringList findAllSubDirs(const TQString& dir);
  int stringHash(const TQString& str);
  /** take advantage string collisions to reduce memory
  */
  TQString shareString(const TQString& str);

  extern TQColor contrastColor;
  void updateContrastColor(const TQColorGroup& cg);
  TQColor blendColors(const TQColor& color1, const TQColor& color2, int percent);
  TQString minutes(int seconds);
  TQString saveLocation(const TQString& dir);

  KLibrary* openLibrary(const TQString& libName);

namespace GUI {
  class CursorSaver {
  public:
    CursorSaver(const TQCursor& cursor = TQt::waitCursor);
    ~CursorSaver();
    void restore();
  private:
    bool m_restored : 1;
  };
}

}

#endif
