/***************************************************************************
    copyright            : (C) 2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_NEWSTUFF_MANAGER_H
#define TELLICO_NEWSTUFF_MANAGER_H

class KArchiveDirectory;
class KURL;
class KTempFile;

#include <tqobject.h>
#include <tqptrlist.h>

class TQStringList;

namespace KNS {
  class Entry;
}
namespace TDEIO {
  class Job;
}

namespace Tellico {
  namespace NewStuff {

class NewScript;

enum DataType {
  EntryTemplate,
  DataScript
};

enum InstallStatus {
  NotInstalled,
  OldVersion,
  Current
};

struct DataSourceInfo {
  DataSourceInfo() : isUpdate(false) {}
  TQString specFile; // full path of .spec file
  TQString sourceName;
  TQString sourceExec; // full executable path of script
  bool isUpdate : 1; // whether the info is for an updated source
};

class Manager : public TQObject {
TQ_OBJECT
  

public:
  Manager(TQObject* parent);
  ~Manager();

  void install(DataType type, KNS::Entry* entry);
  TQPtrList<DataSourceInfo> dataSourceInfo() const { return m_infoList; }

  bool installTemplate(const KURL& url, const TQString& entryName = TQString());
  bool removeTemplate(const TQString& name);

  bool installScript(const KURL& url);
  bool removeScript(const TQString& name);

  static InstallStatus installStatus(KNS::Entry* entry);
  static bool checkCommonFile();

signals:
  void signalInstalled(KNS::Entry* entry);

private slots:
  void slotDownloadJobResult(TDEIO::Job* job);
  void slotInstallFinished();

private:
  static TQStringList archiveFiles(const KArchiveDirectory* dir,
                                  const TQString& path = TQString());

  static TQString findXSL(const KArchiveDirectory* dir);
  static TQString findEXE(const KArchiveDirectory* dir);

  typedef TQPair<KNS::Entry*, DataType> EntryPair;
  TQMap<TDEIO::Job*, EntryPair> m_jobMap;
  TQMap<KURL, TQString> m_urlNameMap;
  TQMap<const NewScript*, KNS::Entry*> m_scriptEntryMap;
  TQPtrList<DataSourceInfo> m_infoList;
  KTempFile* m_tempFile;
};

  }
}

#endif
