/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef IMAGE_H
#define IMAGE_H

#include <tqimage.h>
#include <tqstring.h>

class KPixmapIO;

namespace Tellico {
  class ImageFactory;
  class FileHandler;

  namespace Data {

/**
 * @author Robby Stephenson
 */
class Image : public TQImage {

friend class Tellico::ImageFactory;
friend class Tellico::FileHandler;

public:
  ~Image();

  const TQString& id() const { return m_id; };
  const TQCString& format() const { return m_format; };
  TQByteArray byteArray() const;
  bool isNull() const;
  bool linkOnly() const { return m_linkOnly; }
  void setLinkOnly(bool l) { m_linkOnly = l; }

  TQPixmap convertToPixmap() const;
  TQPixmap convertToPixmap(int width, int height) const;

  static TQCString outputFormat(const TQCString& inputFormat);
  static TQByteArray byteArray(const TQImage& img, const TQCString& outputFormat);
  static TQString idClean(const TQString& id);

private:
  Image();
  explicit Image(const TQString& filename);
  Image(const TQImage& image, const TQString& format);
  Image(const TQByteArray& data, const TQString& format, const TQString& id);

  //disable copy
  Image(const Image&);
  Image& operator=(const Image&);

  void setID(const TQString& id);
  void calculateID();

  TQString m_id;
  TQCString m_format;
  bool m_linkOnly : 1;

  static KPixmapIO* s_pixmapIO;
  static KPixmapIO* io();
};

class ImageInfo {
public:
  ImageInfo() {}
  explicit ImageInfo(const Image& img);
  ImageInfo(const TQString& id, const TQCString& format, int w, int h, bool link);
  bool isNull() const { return id.isEmpty(); }
  TQString id;
  TQCString format;
  bool linkOnly : 1;

  int width(bool loadIfNecessary=true) const;
  int height(bool loadIfNecessary=true) const;

private:
  mutable int m_width;
  mutable int m_height;
};

  } // end namespace
} // end namespace

inline bool operator== (const Tellico::Data::Image& img1, const Tellico::Data::Image& img2) {
  return img1.id() == img2.id();
}

#endif
