/***************************************************************************
                          assoctexteditorimpl.h - Associated text editor implementation
                             -------------------
    copyright            : (C) 2003    Marc Britton <consume@optusnet.com.au>
                           (C) 2004    Michal Rudolf <mrudolf@kdewebdev.org>
                           (C) 2006    Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef _HAVE_ASSOCTEXTEDITORIMPL_H_
#define _HAVE_ASSOCTEXTEDITORIMPL_H_

#include <tqdict.h>
#include <tqstringlist.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqobject.h>
#include <tqmap.h>
#include <tqptrvector.h>
#include <tqpixmap.h>


#include "assoctexteditor.h"
#include <kommanderwidget.h>

class FormWindow;
class PropertyEditor;

namespace KTextEditor {
  class EditInterface;
  class Document;
  class View;
}

namespace KParts{
  class PartManager;
}

class TDEAction;
class TDEPopupMenu;

class AssocTextEditor : public AssocTextEditorBase
{
  TQ_OBJECT
  
public:
  AssocTextEditor(TQWidget*, FormWindow*, PropertyEditor*, KParts::PartManager *partManager, TQWidget*, const char* = 0, bool = true);
  ~AssocTextEditor();
  // Set interface for given widget.
  void setWidget(TQWidget *);
  // Save changes for current widget
  void save() const;
  // Return population text for current widget
  TQString populationText() const;
  // Return associated text for current widget
  TQStringList associatedText() const;

public slots:
  // Current script text has changed - save it in m_atdict
  void textEditChanged();
  // Current widget has changed - store script and update interface
  void widgetChanged(int);
  // Current script has changed - store script and show new script
  void stateChanged(int);
  // Select widget via widget tree dialog
  void selectWidget();

  // Functions for script editing:

  // Insert given text at cursor position for current widget and state
  void insertAssociatedText(const TQString&);
  // Select file and insert its content at cursor position
  void insertFile();
  // Open function browser and insert chosen function at cursor position
  void insertFunction();
  // Insert selected function at cursor position
  void insertWidgetName(int);

protected:
  virtual void closeEvent(TQCloseEvent * e);

protected slots:

  void slotHighlightingChanged(int mode);

private:
  bool useInternalParser();

  // Current widget
  TQWidget *m_widget;
  KommanderWidget* m_kommanderWidget;
//FIXME: could it be done more cleanly?
  // Current form and property editor
  FormWindow* m_formWindow;
  PropertyEditor* m_propertyEditor;
  // Current state
  TQString m_currentState;
  // List of states for current widget
  TQStringList m_states;
  // Current widget list
  TQDict<TQWidget> m_widgetList;
  // Dictionary for current widget; contains pairs (state, script associated with current state)
  TQMap<TQString, TQString> m_atdict;
  // Current population text
  TQString m_populationText;
  // Non-enmpty script pixmap
  TQPixmap scriptPixmap;

  // Create list of all widgets on the same dialog as current widget
  // Set store to true, to update m_widgetList;
  TQStringList buildWidgetList();
  // Convert widget to string displayed in combos
  // If formatted, return formatted string, else just widget's name
  TQString widgetToString(TQWidget* widget, bool formatted = true);
  // Conver combo string to widget
  TQWidget* widgetFromString(const TQString& name);

  KTextEditor::EditInterface *associatedTextEdit;
  KTextEditor::Document *doc;
  KTextEditor::View *view;
  TDEPopupMenu *highlightPopup;
  int oldHlMode;
  bool readOnly;
  TDEAction *readOnlyAction;
};

#endif
