/***************************************************************************
 *   Copyright (C) 2003 by Gulmini Luciano                                          *
 *   gulmini.luciano@student.unife.it                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef SHORTHANDFORMER_H
#define SHORTHANDFORMER_H

/**
@author Gulmini Luciano
*/
#include <tqmap.h>
class TQString;
class TQStringList;

class ShorthandFormer{
public:
    ShorthandFormer(){}
    ShorthandFormer( TQMap<TQString,TQString> m );
    ~ShorthandFormer(){}
    TQString compress();
    TQMap<TQString,TQString> expand(const TQString& propertyName, const TQString& propertyValue);
    static TQStringList SHFormList();

private:
    TQMap<TQString,TQString> m_properties;
    TQString cue_after,
               cue_before,
               pause_before,
               pause_after,
               background_color,
               background_image,
               background_repeat,
               background_attachment,
               background_position,
               border_top_style,
               border_top_color,
               border_top_width,
               border_left_style,
               border_left_color,
               border_left_width,
               border_right_style,
               border_right_color,
               border_right_width,
               border_bottom_style,
               border_bottom_color,
               border_bottom_width,
               outline_style,
               outline_color,
               outline_width,
               list_style_type,
               list_style_image,
               list_style_position,
               font_style,
               font_variant,
               font_weight,
               font_size,
               line_height,
               font_family,
               margin_top,
               margin_bottom,
               margin_left,
               margin_right,
               padding_top,
               padding_bottom,
               padding_left,
               padding_right;

private:
  TQString compressCueProp();
  TQString compressPauseProp();
  TQString compressPaddingProp();
  TQString compressMarginProp();
  TQString compressFontProp();
  TQString compressBackgroundProp();
  TQString compressOutlineProp();
  TQString compressListStyleProp();
  TQString compressBorderStyleProp();
  TQString compressBorderWidthProp();
  TQString compressBorderColorProp();
  TQString compressBorderProp();

  TQString compressImplementation( const TQString& prop, const TQString& t, const TQString& b, const TQString& r, const TQString& l, const TQString& defValue);
  TQString compressImplementation2( const TQString& prop, const TQString& after, const TQString& before, const TQString& defValue);
  TQString compressImplementation3( const TQString& prop, const TQString& p1, const TQString& p2, const TQString& p3);

  TQMap<TQString,TQString> expandCueProp(const TQStringList& l);
  TQMap<TQString,TQString> expandPauseProp(const TQStringList& l);
  TQMap<TQString,TQString> expandBackgroundProp(const TQStringList& l);
  TQMap<TQString,TQString> expandFontProp(const TQStringList& l);
  TQMap<TQString,TQString> expandOutlineProp(const TQStringList& l);
  TQMap<TQString,TQString> expandListstyleProp(const TQStringList& l);
  TQMap<TQString,TQString> expandBoxSide(const TQString& subPropName, const TQStringList& l);
  TQMap<TQString,TQString> expandBorderProp(const TQStringList& l);
  TQMap<TQString,TQString> expandBox(const TQString& subPropName, const TQStringList& l);
  TQMap<TQString,TQString> expandPaddingProp(const TQStringList& l);
  TQMap<TQString,TQString> expandMarginProp(const TQStringList& l);

  TQMap<TQString,TQString> expandImplementation(const TQString& propertyName, const TQStringList& l);
  TQMap<TQString,TQString> expandImplementation2(const TQString& propertyName, const TQStringList& l);
 };

#endif
