/***************************************************************************
                          fontfamilychooser.cpp  -  description
                             -------------------
    begin                : mer lug 23 11:20:17 CEST 2003
    copyright            : (C) |YEAR| by si2003    email                : gulmini.luciano@student.unife.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "fontfamilychooser.h"
 
#include <tqfontdatabase.h>
#include <tqstringlist.h>
#include <tqlistbox.h>
#include <tqfont.h>
#include <tdelocale.h>
#include <tqiconset.h>
#include <tqpixmap.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <tdeglobalsettings.h>
#include <tqregexp.h>
#include <tqlineedit.h>
#include <tqwhatsthis.h>

#include<kdebug.h>

fontFamilyChooser::fontFamilyChooser(TQWidget* parent, const char *name) : fontFamilyChooserS(parent,name){

  TQFont tmpFont( TDEGlobalSettings::generalFont().family(), 64, TQFont::Black );
  lePreview->setMinimumHeight( lePreview->fontMetrics().lineSpacing() );
  lePreview->setAlignment(TQt::AlignCenter);
  TQFont font;
  font.setPointSize(20);
  lePreview->setFont(font);
  lePreview->setText(i18n("The Quick Brown Fox Jumps Over The Lazy Dog"));
  
  TQFontDatabase fdb;
  TQStringList families = fdb.families();
  for ( TQStringList::Iterator it = families.begin(); it != families.end(); ++it ) {
    if( (*it).contains('[') !=0  ) 
      it = families.remove(it);
  }
  
  if( families.count() != 0 ) lbAvailable->insertStringList(families);
  
       
  TQIconSet iconSet = SmallIconSet(TQString::fromLatin1("forward"));
  TQPixmap pixMap = iconSet.pixmap( TQIconSet::Small, TQIconSet::Normal );
  pbAdd->setIconSet(iconSet);
  pbAdd->setFixedSize( pixMap.width()+8, pixMap.height()+8 );
  
  iconSet = SmallIconSet(TQString::fromLatin1("back"));
  pbRemove->setIconSet(iconSet);
  pbRemove->setFixedSize( pixMap.width()+8, pixMap.height()+8 );
  
   iconSet = SmallIconSet(TQString::fromLatin1("go-up"));
  pbMoveUp->setIconSet(iconSet);
  pbMoveUp->setFixedSize( pixMap.width()+8, pixMap.height()+8 );
  
  iconSet = SmallIconSet(TQString::fromLatin1("go-down"));
  pbMoveDown->setIconSet(iconSet);
  pbMoveDown->setFixedSize( pixMap.width()+8, pixMap.height()+8 );

  connect(pbAdd, TQ_SIGNAL(clicked()), this ,TQ_SLOT( addFont() ));
  connect( lbAvailable, TQ_SIGNAL( highlighted( const TQString& ) ), this, TQ_SLOT( updatePreview( const TQString&) ) );
  connect( lbAvailable, TQ_SIGNAL( highlighted( const TQString& ) ), this, TQ_SLOT( setCurrentSelectedAvailableFamilyFont( const TQString&) ) );
  connect( lbGeneric, TQ_SIGNAL( highlighted( const TQString& ) ), this, TQ_SLOT( updatePreview( const TQString&) ) );
  connect( lbGeneric, TQ_SIGNAL( highlighted( const TQString& ) ), this, TQ_SLOT( setCurrentSelectedGenericFamilyFont( const TQString&) ) );
  connect( lbSelected, TQ_SIGNAL( highlighted( const TQString& ) ), this, TQ_SLOT( updatePreview( const TQString&) ) );
  connect( lbSelected, TQ_SIGNAL( highlighted( int ) ), this, TQ_SLOT( setCurrentSelectedFont( int ) ) );
  connect( lbSelected, TQ_SIGNAL( highlighted( const TQString& ) ), this, TQ_SLOT( setCurrentSelectedFont( const TQString&) ) );
  connect( pbRemove, TQ_SIGNAL( clicked() ), this, TQ_SLOT( removeFont() ) );
  connect( pbMoveUp, TQ_SIGNAL( clicked() ), this, TQ_SLOT( moveFontUp() ) );
  connect( pbMoveDown, TQ_SIGNAL( clicked() ), this, TQ_SLOT( moveFontDown() ) );
  
  TQWhatsThis::add(lbAvailable,i18n("These are the names of the available fonts on your system"));
  TQWhatsThis::add(lbGeneric,i18n("These are the names of the generic fonts "));
  TQWhatsThis::add(lbSelected,i18n("These are the names of the generic fonts you have selected  "));
  TQWhatsThis::add(pbAdd,i18n("Click this to add a font to your style sheet"));
  TQWhatsThis::add(pbRemove,i18n("Click this to remove a font from your style sheet"));
  TQWhatsThis::add(pbMoveUp,i18n("Click this to make the font more preferable than the preceeding one"));
  TQWhatsThis::add(pbMoveDown,i18n("Click this to make the font less preferable than the following one"));
  
}
 
fontFamilyChooser::~fontFamilyChooser(){} 

void fontFamilyChooser::updatePreview(const TQString& s){
  lePreview->setFont(TQFont(s,20));
}

void fontFamilyChooser::addFont(){
  lbSelected->insertItem( m_currentSelectedFont );
  switch(m_fontOrigin) {
    case available: lbAvailable->removeItem(lbAvailable->index(lbAvailable->findItem(m_currentSelectedFont)));
                             break;
    case generic : lbGeneric->removeItem(lbGeneric->index(lbGeneric->findItem(m_currentSelectedFont)));
                             break;
  }
}

void fontFamilyChooser::setCurrentSelectedAvailableFamilyFont(const TQString& f){
  m_fontOrigin = available;
  m_currentSelectedFont = f;
   m_selectedFontMap[f] = available;
}

void fontFamilyChooser::setCurrentSelectedGenericFamilyFont(const TQString& f){
  m_fontOrigin = generic;
  m_currentSelectedFont =f;
  m_selectedFontMap[f] = generic;
}

void  fontFamilyChooser::moveFontUp(){ 
  if(m_currentSelectedFontIndex == 0) return;
  int dummyIndex = m_currentSelectedFontIndex; 
  lbSelected->insertItem( lbSelected->text(m_currentSelectedFontIndex ), dummyIndex -1); 
  lbSelected->removeItem(dummyIndex + 1);
  lbSelected->setSelected( dummyIndex -1, true);                            
}

void  fontFamilyChooser::moveFontDown(){
  if((unsigned int)m_currentSelectedFontIndex == lbSelected->count()) return;
  int dummyIndex = m_currentSelectedFontIndex;
  lbSelected->insertItem( lbSelected->text(m_currentSelectedFontIndex ), dummyIndex + 2);
  lbSelected->removeItem(dummyIndex);
  lbSelected->setSelected(dummyIndex +1, true);
}

void fontFamilyChooser::removeFont(){
  TQString dummyFont(m_currentSelectedFont);// since removeItem emits highlighted signal, after
                                                                           //  removeItem call the value of m_currentSelectedFont
                                                                           // is actually the font after m_currentSelectedFont and so
                                                                           // we must save m_currentSelectedFont value in dummyFont
  lbSelected->removeItem( m_currentSelectedFontIndex );
  switch(m_selectedFontMap[dummyFont]) {
    case available: lbAvailable->insertItem(dummyFont);
                             lbAvailable->sort();
                             break;
    case generic : lbGeneric->insertItem(dummyFont);
                            lbGeneric->sort();
                            break;
  }
  
}

TQStringList fontFamilyChooser::fontList(){
  TQStringList list;
  TQListBoxItem *item = lbSelected->firstItem();
  while( item != 0 ){
    if( item->text().contains( TQRegExp("\\W") ) ) list.append( "'" + item->text() + "'" );
    else list.append( item->text() );
    item = item->next();  
  }
  return list;
}

void fontFamilyChooser::setInitialValue(const TQString& s){
  TQStringList familyList = TQStringList::split(",",s);                 
  for ( TQStringList::Iterator it = familyList.begin(); it != familyList.end(); ++it ) {
    (*it).remove("'");
    (*it).remove("\"");
    lbSelected->insertItem((*it).stripWhiteSpace());
  }  
}

#include "fontfamilychooser.moc"
