/***************************************************************************
                          subdialog.h - Subdialog widget 
                             -------------------
    copyright            : (C) 2002 by Marc Britton
    email                : consume@optusnet.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef _HAVE_SUBDIALOG_H_
#define _HAVE_SUBDIALOG_H_

/* KDE INCLUDES */

/* QT INCLUDES */
#include <tqpushbutton.h>
#include <tqobject.h>
#include <tqstring.h>
#include <tqstringlist.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>
#include <kommander_export.h>
class TQWidget;
class TQDialog;

class TQShowEvent;
class KOMMANDER_EXPORT SubDialog : public TQPushButton, public KommanderWidget
{
  TQ_OBJECT
  
  
  TQ_PROPERTY(TQString populationText READ populationText WRITE setPopulationText DESIGNABLE false)
  TQ_PROPERTY(TQString kmdrFile READ kmdrFile WRITE setKmdrFile)
  TQ_PROPERTY(TQStringList associations READ associatedText WRITE setAssociatedText DESIGNABLE false)
  TQ_PROPERTY(bool KommanderWidget READ isKommanderWidget)
public:
  SubDialog(TQWidget *a_parent, const char *a_name);
  ~SubDialog();
  
  virtual bool isKommanderWidget() const;
  virtual void setAssociatedText(const TQStringList&);
  virtual TQStringList associatedText() const;
  virtual TQString currentState() const;
  virtual TQString populationText() const;
  virtual void setPopulationText(const TQString&);
  TQString kmdrFile() const;

  virtual TQString handleDCOP(int function, const TQStringList& args);  
public slots:
  void setKmdrFile(TQString);
  virtual void showDialog();
  virtual void slotFinished();
  virtual void populate();
signals:
  void widgetOpened();
  void widgetTextChanged(const TQString &);
protected:
  TQDialog *m_dialog;
  TQString m_kmdrFile;
  void showEvent( TQShowEvent *e );
private:
};

#endif
