/*
 *  Copyright (C) 2003 Roberto Raggi (roberto@kdevelop.org)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef QUICKOPENCLASSDIALOG_H
#define QUICKOPENCLASSDIALOG_H

#include "quickopendialog.h"
#include <codemodel.h>
#include <tqstringlist.h>

class QuickOpenPart;

class QuickOpenClassDialog : public QuickOpenDialog
{
    TQ_OBJECT
  
public:
    QuickOpenClassDialog(QuickOpenPart* part, TQWidget* parent = 0, const char* name = 0, bool modal = true, WFlags fl = 0 );
    virtual ~QuickOpenClassDialog();

public slots:
    virtual void slotExecuted( TQListBoxItem* );
    virtual void slotReturnPressed();

protected:
    void findAllClasses( TQStringList& classList );
    void findAllClasses( TQStringList& classList, const ClassDom klass );
    void findAllClasses( TQStringList& classList, const NamespaceDom ns );

    ClassList findClass( const TQString& name );
    ClassList findClass( TQStringList& path, const NamespaceDom ns );
    ClassList findClass( TQStringList& path, const ClassList klasses );
    ClassList findClass( TQStringList& path, const ClassDom klass );

protected slots:
    virtual void accept();
};

#endif

