#include <tqtimer.h>


#include <tdeapplication.h>
#include <kdebug.h>
#include <kstatusbar.h>
#include <tdemainwindow.h>
#include <tdeconfig.h>
#include <tdeversion.h>
#include <tdestandarddirs.h>
#include <tdeglobal.h>
#include <tdeactioncollection.h>

#include "toplevel.h"
#include "partcontroller.h"
#include "api.h"
#include "projectmanager.h"

#include "core.h"


Core *Core::s_instance = 0;


Core *Core::getInstance()
{
  if (!s_instance)
    s_instance = new Core;
  return s_instance;
}

void Core::setupShourtcutTips(KXMLGUIClient * client)
{
  TQPtrList<KXMLGUIClient> clients;
  if (client != 0)
    clients.append(client);
  else
    clients = TopLevel::getInstance()->main()->guiFactory()->clients();
  
  for( TQPtrListIterator<KXMLGUIClient> it(clients); it.current(); ++it ) {
    TDEActionCollection *actionCollection = (*it)->actionCollection();
    for (int i = 0; i < actionCollection->count(); i++) {
      TDEAction *action = actionCollection->action(i);
            
      TQString tooltip = action->toolTip();
      if (tooltip.isEmpty())
        tooltip = action->text().remove('&');
      else {
        int i = tooltip.findRev('(');
        if (i > 0) tooltip = tooltip.left(i).stripWhiteSpace();
      }

      TQString shortcut = action->shortcutText();
      if (!shortcut.isEmpty())
        tooltip += " (" + shortcut + ")";
        action->setToolTip(tooltip);
      }
  }
}

Core::Core()
  : KDevCore()
{
}


Core::~Core()
{
}

bool Core::queryClose()
{
  // save the the project to open it automaticly on startup if needed
  TDEConfig* config = tdeApp->config();
  config->setGroup("General Options");
  config->writePathEntry("Last Project",ProjectManager::getInstance()->projectFile().url());
  
  if ( !PartController::getInstance()->querySaveFiles() )
	  return false;
  
  if ( !ProjectManager::getInstance()->closeProject( true ) )
      return false;
  
  if ( !PartController::getInstance()->readyToClose() )
      return false;
  
  return true;
}


void Core::running(KDevPlugin * which, bool runs)
{
  emit activeProcessChanged( which, runs );
}


void Core::fillContextMenu(TQPopupMenu *popup, const Context *context)
{
  emit contextMenu(popup, context);
}


void Core::openProject(const TQString& projectFileName)
{
  ProjectManager::getInstance()->loadProject(KURL( projectFileName ));
}

namespace MainWindowUtils{
TQString beautifyToolTip(const TQString& text)
{
    TQString temp = text;
    temp.replace(TQRegExp("&"), "");
    temp.replace(TQRegExp("\\.\\.\\."), "");
    return temp;
}
}

#include "core.moc"
