/***************************************************************************
 *   Copyright (C) 2002-2004 by Alexander Dymo                             *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <tqlayout.h>
#include <tqpainter.h>
#include <tqpushbutton.h>
#include <klineedit.h>

#ifndef PURE_QT
#include <kcharselect.h>
#include <tdelocale.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>
#include <tqdialog.h>
#endif

#include "psymbolcombo.h"

namespace PropertyLib{

PSymbolCombo::PSymbolCombo(MultiProperty *property, TQWidget *parent, const char *name)
    :PropertyWidget(property, parent, name)
{
    l = new TQHBoxLayout(this);
    m_edit = new KLineEdit(this);
    m_edit->setSizePolicy(TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding);
    m_edit->setMaxLength(1);
    l->addWidget(m_edit);
    m_select = new TQPushButton("...", this);
    m_select->setSizePolicy(TQSizePolicy::Maximum, TQSizePolicy::MinimumExpanding);
    l->addWidget(m_select);

#ifdef PURE_QT
    m_select->hide();
#endif

    connect(m_select, TQ_SIGNAL(clicked()), this, TQ_SLOT(selectChar()));
    connect(m_edit, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(updateProperty(const TQString&)));
}

TQVariant PSymbolCombo::value() const
{
    if (!(m_edit->text().isNull()))
        return TQVariant(TQString("%1").arg(m_edit->text().at(0).unicode()));
    else
        return TQVariant(0);
}

void PSymbolCombo::setValue(const TQVariant &value, bool emitChange)
{
    if (!(value.isNull()))
    {
        disconnect(m_edit, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(updateProperty(const TQString&)));
        m_edit->setText(TQChar(value.toInt()));
        connect(m_edit, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(updateProperty(const TQString&)));
        if (emitChange)
            emit propertyChanged(m_property, value);
    }
}

void PSymbolCombo::selectChar()
{
#ifndef PURE_QT
    TQDialog* dia = new TQDialog(this, "select_dialog", true);
    TQVBoxLayout *dv = new TQVBoxLayout(dia, 2);

    KCharSelect *select = new KCharSelect(dia, "select_char");
    dv->addWidget(select);

    TQHBoxLayout *dh = new TQHBoxLayout(dv, 6);
    KPushButton *pbOk = new KPushButton(KStdGuiItem::ok(), dia);
    KPushButton *pbCancel = new KPushButton(KStdGuiItem::cancel(), dia);
    TQSpacerItem *si = new TQSpacerItem(30, 0, TQSizePolicy::Expanding, TQSizePolicy::Expanding);

    connect(pbOk, TQ_SIGNAL(clicked()), dia, TQ_SLOT(accept()));
    connect(pbCancel, TQ_SIGNAL(clicked()), dia, TQ_SLOT(reject()));

    dh->addItem(si);
    dh->addWidget(pbOk);
    dh->addWidget(pbCancel);

    if (!(m_edit->text().isNull()))
        select->setChar(m_edit->text().at(0));

    if (dia->exec() == TQDialog::Accepted)
    {
        m_edit->setText(select->chr());
    }
    delete dia;
#endif
}

void PSymbolCombo::updateProperty(const TQString& val)
{
    emit propertyChanged(m_property, TQVariant(TQString("%1").arg(val.at(0).unicode())));
}

void PSymbolCombo::drawViewer(TQPainter *p, const TQColorGroup &cg, const TQRect &r, const TQVariant &value)
{
    p->setBrush(cg.background());
    p->setPen(TQt::NoPen);
    p->drawRect(r);
    p->drawText(r, TQt::AlignLeft | TQt::AlignVCenter | TQt::SingleLine, TQChar(value.toInt()));
}

}

#ifndef PURE_QT
#include "psymbolcombo.moc"
#endif
