/***************************************************************************
*   Copyright (C) 2004 by ian geiser                                      *
*   geiseri@sourcextreme.com                                              *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
***************************************************************************/
#include "tdescriptactionmanager.h"
#include <tdeparts/part.h>
#include <tdeparts/componentfactory.h>
#include <tdeapplication.h>
#include <tdedesktopfile.h>
#include <tdestandarddirs.h>

#include <tdelocale.h>
#include <tdemessagebox.h>
#include <kdebug.h>
#include <scriptinterface.h>
#include <tdeaction.h>
#include <tqfileinfo.h>
#include <tqtimer.h>

KScriptAction::KScriptAction( const TQString &scriptDesktopFile, TQObject *interface, TDEActionCollection *ac )
    : TQObject(interface), KScriptClientInterface( )
{
    m_interface = 0L;
    m_action = 0L;
    m_isValid = false;
    m_refs = 0;
    // Read the desktop file
    if(TDEDesktopFile::isDesktopFile(scriptDesktopFile))
    {
        TDEDesktopFile desktop(scriptDesktopFile, true);
        TQFileInfo scriptPath(scriptDesktopFile);
        
        m_scriptFile = scriptPath.dirPath(true) + "/" + desktop.readEntry("X-TDE-ScriptName", "");
        m_scriptName = desktop.readName();
        m_scriptType = desktop.readType();
        TQString scriptTypeQuery = "([X-TDE-Script-Runner] == '" + m_scriptType + "')";
	TDETrader::OfferList offers = TDETrader::self()->query( "KScriptRunner/KScriptRunner", scriptTypeQuery );
        if ( !offers.isEmpty() )
        {
            m_action = new TDEAction(m_scriptName, TDEShortcut(), this, TQ_SLOT(activate()), ac, "script");
            m_isValid = true;
            m_timeout = new TQTimer(this);
            TQString icon = desktop.readIcon();
            m_action->setStatusText(desktop.readComment());
                if( !icon.isEmpty() ) 
                    m_action->setIcon(icon);
            m_action->setShortcutConfigurable(true);
            connect( m_timeout, TQ_SIGNAL(timeout()), TQ_SLOT(cleanup()) );
        }
    }
}

KScriptAction::~KScriptAction()
{
    if( m_interface ) delete m_interface;
    if( m_action ) delete m_action;
}



TDEAction * KScriptAction::action( )
{
    return m_action;
}

void KScriptAction::activate( )
{
    if( m_interface == 0L)
    {
        TQString scriptTypeQuery = "([X-TDE-Script-Runner] == '" + m_scriptType + "')";
        m_interface= KParts::ComponentFactory::createInstanceFromQuery<KScriptInterface>( "KScriptRunner/KScriptRunner", scriptTypeQuery, this );
	if ( m_interface != 0L)
        {
            m_interface->ScriptClientInterface= this;
            if( m_scriptMethod.isEmpty() )
                m_interface->setScript(m_scriptFile);
            else
                m_interface->setScript(m_scriptFile, m_scriptMethod);
            connect(this, TQ_SIGNAL(done(KScriptClientInterface::Result, const TQVariant &)), this, TQ_SLOT(scriptFinished()));
        }
        else
        {
            KMessageBox::sorry(0, i18n("Unable to get KScript Runner for type \"%1\".").arg(m_scriptType), i18n("KScript Error"));
	    kdDebug() << "Query string: " << scriptTypeQuery << endl;
            return;
        }
    }
    m_interface->run(parent(), TQVariant());
    m_timeout->start(60000,false); // after 1 minute unload
    m_refs++;
}

void KScriptAction::cleanup() 
{
    if( m_interface && m_refs == 0)
    {
	delete m_interface;
	m_interface = 0L;
    }
}

void KScriptAction::scriptFinished()
{
    m_refs--;
}

KScriptActionManager::KScriptActionManager(  TQObject *parent, TDEActionCollection * ac ) : TQObject(parent), m_ac(ac)
{
    m_actions.setAutoDelete(true);
}

KScriptActionManager::~ KScriptActionManager( )
{
    m_actions.clear();
}

TQPtrList< TDEAction > KScriptActionManager::scripts( TQObject * interface , const TQStringList &dirs) const
{
    m_actions.clear();
    TQPtrList<TDEAction> actions;
    TQStringList scripts;

    scripts += TDEGlobal::dirs()->findAllResources("data",
        TQString(tdeApp->name())+"/scripts/*.desktop", false, true );

    for( TQStringList::ConstIterator it = dirs.begin(); it != dirs.end(); ++it)
    {
        scripts += TDEGlobal::dirs()->findAllResources("data",
        (*it)+"/*.desktop", false, true );
    }

    for (TQStringList::Iterator it = scripts.begin(); it != scripts.end(); ++it )
    {
        kdDebug() << "Loading " << *it << endl;
        KScriptAction *script = new KScriptAction(*it, interface, m_ac);
	if( script->isValid())
	{
	  actions.append(script->action());
	  m_actions.append(script);
	  connect(script, TQ_SIGNAL(error( const TQString&)), this, 
	  	TQ_SIGNAL(scriptError( const TQString&)));
	  connect(script, TQ_SIGNAL(warning( const TQString&)), this, 
	  	TQ_SIGNAL(scriptWarning( const TQString&)));
	  connect(script, TQ_SIGNAL(output( const TQString&)), this,
	  	TQ_SIGNAL(scriptOutput( const TQString&)));
	  connect(script, TQ_SIGNAL(progress( int )), this, 
	  	TQ_SIGNAL(scriptProgress(int)));
	  connect(script, TQ_SIGNAL(done( KScriptClientInterface::Result, const TQVariant &)),this,
	  	TQ_SIGNAL(scriptDone( KScriptClientInterface::Result, const TQVariant &)));
	}
	else
	  delete script;
    }
    return actions;
}

bool KScriptAction::isValid( ) const
{
  return m_isValid;
}

#include "tdescriptactionmanager.moc"
