/***************************************************************************
 *   Copyright (C) 2003 by Harald Fernengel                                *
 *   harry@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "sqlactions.h"

#include <tqpopupmenu.h>
#include <tqstringlist.h>
#include <tqsqldatabase.h>

#include <kdebug.h>
#include <tdelocale.h>
#include <tdetoolbar.h>
#include <kiconloader.h>
#include <kcombobox.h>

#include "kdevplugin.h"
#include "kdevlanguagesupport.h"
#include "sqlsupport_part.h"

SqlListAction::SqlListAction(SQLSupportPart *part, const TQString &text, 
				 const TDEShortcut& cut,
                                 const TQObject *receiver, const char *slot,
                                 TDEActionCollection *parent, const char *name)
    : KWidgetAction( m_combo = new KComboBox(), text, cut, 0, 0, parent, name), m_part(part)
{
    m_combo->setEditable( false );
    m_combo->setAutoCompletion( true );

    m_combo->setMinimumWidth( 200 );
    m_combo->setMaximumWidth( 400 );

    connect( m_combo, TQ_SIGNAL(activated(const TQString&)), receiver, slot );
    connect( m_combo, TQ_SIGNAL(activated(int)), this, TQ_SLOT(activated(int)) );

    setShortcutConfigurable( false );
    setAutoSized( true );

    refresh();
}


void SqlListAction::setCurrentConnectionName(const TQString &name)
{
    int idx = m_part->connections().findIndex( name );
    if ( idx < 0 )
        m_combo->setCurrentItem( 0 );
    else
        m_combo->setCurrentItem( idx + 1 );
}


TQString SqlListAction::currentConnectionName() const
{
    if ( m_combo->currentItem() <= 0 )
        return TQString();
    return m_part->connections()[ m_combo->currentItem() - 1 ];
}

void SqlListAction::activated(int idx)
{
    if (idx < 1 || (int)m_part->connections().count() <= idx)
        return;
    const TQSqlDatabase *db = TQSqlDatabase::database(m_part->connections()[idx], true);
    m_combo->changeItem( db->isOpen() ? SmallIcon( "ok" ) : SmallIcon( "no" ), 
                         m_combo->text(idx), idx );
}

void SqlListAction::refresh()
{
    const TQStringList& dbc = m_part->connections();

    m_combo->clear();
    m_combo->insertItem( i18n("<no database server>") );

    TQString cName;
    for ( TQStringList::ConstIterator it = dbc.begin(); it != dbc.end(); ++it ) {

        TQSqlDatabase* db = TQSqlDatabase::database( (*it), false );
        if ( !db ) {
            kdDebug( 9000 ) << "Could not find database connection " << (*it) << endl;
            m_combo->insertItem( SmallIcon( "no" ), i18n("<error - no connection %1>").arg( *it ) );
            continue;
        }
        cName = db->driverName();
        cName.append( "://" ).append( db->userName() ).append( "@" ).append( db->hostName() );
        cName.append( "/" ).append( db->databaseName() );

        m_combo->insertItem( db->open() ? SmallIcon( "ok" ) : SmallIcon( "no" ), cName );
    }
}


#include "sqlactions.moc"
