/***************************************************************************
 *   Copyright (C) 2002 by Jakob Simon-Gaarde                              *
 *   jsgaarde@tdcspace.dk                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "newwidgetdlg.h"
#include <tqradiobutton.h>
#include <tqstringlist.h>
#include <tqcheckbox.h>
#include <tqmessagebox.h>
#include <tdefiledialog.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <domutil.h>
#include <tqdom.h>
#include <kstdguiitem.h>

#define WIDGET_CAPTION_NAME "widget/property|name=caption/string"
#define WIDGET_CLASS_NAME   "class"
#define WIDGET_SLOTS        "slots"

NewWidgetDlg::NewWidgetDlg(TQStringList &newFileNames,TQWidget* parent, const char* name, bool modal, WFlags fl)
: NewWidgetDlgBase(parent,name,modal,fl),
m_newFileNames(newFileNames)
//=================================================
{
// Remove in kde 3.4 support
	okayButton->setGuiItem(KStdGuiItem::ok());
	cancelButton->setGuiItem(KStdGuiItem::cancel());
}


NewWidgetDlg::~NewWidgetDlg()
//==============================================
{
}


void NewWidgetDlg::subclassingPressed()
//=====================================
{
  TQMessageBox::information(0,"subclassing","");
}


void NewWidgetDlg::templateSelChanged()
//=====================================
{
  TQMessageBox::information(0,"template","");
}

void NewWidgetDlg::accept()
//=========================
{
  TQDomDocument doc;
  DomUtil::openDOMFile(doc,"/home/jsgaarde/programming/tdevelop/domapp/clean_dialog.ui");
  DomUtil::replaceText(doc,WIDGET_CLASS_NAME,"TestClass");
  DomUtil::replaceText(doc,WIDGET_CAPTION_NAME,"Test Dialog");
  TQDomElement slotsElem = DomUtil::elementByPathExt(doc,WIDGET_SLOTS);
  TQDomNodeList slotnodes = slotsElem.childNodes();
  for (unsigned int i=0; i<slotnodes.count();i++)
  {
    TQString msg;
    TQDomElement slotelem = slotnodes.item(i).toElement();
    msg.sprintf("Slotname: %s\nReturns: %s\nAccess: %s",
                    slotelem.text().ascii(),
                    slotelem.attributeNode("returnType").value().ascii(),
                    slotelem.attributeNode("access").value().ascii());
    TQMessageBox::information(0,"Slots",msg);
  }
  DomUtil::saveDOMFile(doc,"/home/jsgaarde/programming/tdevelop/domapp/clean_dialog2.ui");
  NewWidgetDlgBase::accept();
}

