
#ifndef SENSORSENSOR_H
#define SENSORSENSOR_H

#include <tqstring.h>
#include <tqtextcodec.h>
#include <tqmap.h>
#include <tqstringlist.h>
#include <tqregexp.h>
#include <tdeprocess.h>
#include <tdeprocio.h>


#include "sensor.h"

/**
 *
 * Hans Karlsson
 **/
class SensorSensor : public Sensor
{
    TQ_OBJECT
  
public:
    SensorSensor(int interval, char tempUnit);

    ~SensorSensor();

    void update();


private:
    KShellProcess ksp;
    TQString extraParams;

    TQMap<TQString,TQString> sensorMap;
#if defined __FreeBSD__ || defined(Q_OS_NETBSD)
    TQMap<TQString,TQString> sensorMapBSD;
#endif
    TQString sensorResult;

private slots:
    void receivedStdout(TDEProcess *, char *buffer, int);
    void processExited(TDEProcess *);



};

#endif
