/*******************************************************************************
  GPU sensor
  Copyright (C) 2024 Mavridis Philippe <mavridisf@gmail.com>

  This program is free software: you can redistribute it and/or modify it under
  the terms of the GNU General Public License as published by the Free Software
  Foundation, either version 3 of the License, or (at your option) any later
  version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
  You should have received a copy of the GNU General Public License along with
  this program. If not, see <http://www.gnu.org/licenses/>.

  Improvements and feedback are welcome!
*******************************************************************************/

#ifndef GPUSENSOR_H
#define GPUSENSOR_H

// TDE
#include <tdeprocess.h>

// Superkaramba
#include "sensor.h"

class GPUSensor : public Sensor
{
    TQ_OBJECT

    public:
        GPUSensor(TQString driver, TQString gpuId, int interval = 1000);
        ~GPUSensor();

        void update();
        void setMaxValue(SensorParams *sp);

    protected:
        TQString getLoad();

    private:
        TQString m_gpuDriver, m_gpuId, m_buffer;
        TQStringList m_command;
        TDEProcess m_proc;

    public slots:
        void receivedStdout(TDEProcess *proc, char *buffer, int buflen);
        void processExited(TDEProcess *proc);
};

#endif // GPUSENSOR_H