/***************************************************************************
 *   Copyright (C) 2006-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#ifndef __INFO_ENTRY_H
#define __INFO_ENTRY_H

#include <svnqt/lock_entry.h>
#include <svnqt/datetime.h>
#include <svnqt/revision.h>
#include <svnqt/svnqttypes.h>

#include <tqstring.h>

struct svn_info_t;

namespace svn {
  class SVNTQT_EXPORT InfoEntry
  {
public:
    InfoEntry();
    InfoEntry(const svn_info_t*,const char*path);
    InfoEntry(const svn_info_t*,const TQString&path);
    InfoEntry(const InfoEntry&);
    ~InfoEntry();

    void init(const svn_info_t*,const char*path);
    void init(const svn_info_t*,const TQString&path);

    DateTime cmtDate()const;
    DateTime textTime()const;
    DateTime propTime()const;
    bool hasWc()const;
    /**
     * @return lock for that entry
     * @since subversion 1.2
     */
    const LockEntry&lockEntry()const;
    /**
     * @return last commit author of this file
     */
    const TQString&cmtAuthor () const;
    const TQString&Name()const;

    const TQString& checksum()const;
    const TQString& conflictNew()const;
    const TQString& conflictOld()const;
    const TQString& conflictWrk()const;
    const TQString& copyfromUrl()const;
    const TQString& prejfile()const;
    const TQString& reposRoot()const;
    const TQString& url()const;
    const TQString& uuid()const;
    svn_node_kind_t kind()const;
    const Revision& cmtRev()const;
    const Revision& copyfromRev()const;
    const Revision& revision()const;
    svn_wc_schedule_t Schedule()const;

    TQLONG size()const;
    TQLONG working_size()const;
    const TQByteArray&changeList()const;
    svn::Depth depth()const;

    const TQString&prettyUrl()const;

    bool isDir()const;
    TQString prettyUrl(const char*)const;

protected:
    DateTime m_last_changed_date;
    DateTime m_text_time;
    DateTime m_prop_time;
    bool m_hasWc;
    LockEntry m_Lock;
    TQString m_name;
    TQString m_checksum;
    TQString m_conflict_new;
    TQString m_conflict_old;
    TQString m_conflict_wrk;
    TQString m_copyfrom_url;
    TQString m_last_author;
    TQString m_prejfile;
    TQString m_repos_root;
    TQString m_url;
    TQString m_pUrl;
    TQString m_UUID;
    svn_node_kind_t m_kind;
    Revision m_copy_from_rev;
    Revision m_last_changed_rev;
    Revision m_revision;
    svn_wc_schedule_t m_schedule;

    TQLONG m_size;
    TQLONG m_working_size;
    TQByteArray m_changeList;
    svn::Depth m_depth;

protected:
    void init();
  };
}
#endif
