/*
    This file is part of tdepim.

    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "scalixwizard.h"

#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <kdebug.h>
#include <tdecmdlineargs.h>
#include <tdeglobal.h>
#include <tdelocale.h>

static const TDECmdLineOptions options[] =
{
  {"verbose", "Verbose output", 0},
  TDECmdLineLastOption
};

int main(int argc,char **argv)
{
  TDELocale::setMainCatalogue( "tdepimwizards" );

  TDEAboutData aboutData( "scalixwizard", I18N_NOOP( "Scalix Configuration Wizard" ), "0.1" );
  TDECmdLineArgs::init( argc, argv, &aboutData );
  TDECmdLineArgs::addCmdLineOptions( options );

  TDEApplication app;

  TDEGlobal::locale()->insertCatalogue( "libtdepim" );

  TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

  bool verbose = false;
  if ( args->isSet( "verbose" ) ) verbose = true;

  ScalixWizard wizard;

  wizard.exec();
}
