/* WMF Metafile Function Description Table
 * Author: Stefan Taferner <taferner@kde.org>
 */
#ifndef metafunc_h
#define metafunc_h

class TQWinMetaFile;

static const struct MetaFuncRec
{
    const char* name;
    unsigned short func;
    void ( TQWinMetaFile::*method )( long, short* );
} metaFuncTab[] =
  {
      { "SETBKCOLOR",           0x0201, &TQWinMetaFile::setBkColor },
      { "SETBKMODE",            0x0102, &TQWinMetaFile::setBkMode },
      { "SETMAPMODE",           0x0103, &TQWinMetaFile::noop },
      { "SETROP2",              0x0104, &TQWinMetaFile::setRop },
      { "SETRELABS",            0x0105, &TQWinMetaFile::noop },
      { "SETPOLYFILLMODE",      0x0106, &TQWinMetaFile::setPolyFillMode },
      { "SETSTRETCHBLTMODE",    0x0107, &TQWinMetaFile::noop },
      { "SETTEXTCHAREXTRA",     0x0108, &TQWinMetaFile::noop },
      { "SETTEXTCOLOR",         0x0209, &TQWinMetaFile::setTextColor },
      { "SETTEXTJUSTIFICATION", 0x020A, &TQWinMetaFile::noop },
      { "SETWINDOWORG",         0x020B, &TQWinMetaFile::setWindowOrg },
      { "SETWINDOWEXT",         0x020C, &TQWinMetaFile::setWindowExt },
      { "SETVIEWPORTORG",       0x020D, &TQWinMetaFile::noop },
      { "SETVIEWPORTEXT",       0x020E, &TQWinMetaFile::noop },
      { "OFFSETWINDOWORG",      0x020F, &TQWinMetaFile::noop },
      { "SCALEWINDOWEXT",       0x0410, &TQWinMetaFile::noop },
      { "OFFSETVIEWPORTORG",    0x0211, &TQWinMetaFile::noop },
      { "SCALEVIEWPORTEXT",     0x0412, &TQWinMetaFile::noop },
      { "LINETO",               0x0213, &TQWinMetaFile::lineTo },
      { "MOVETO",               0x0214, &TQWinMetaFile::moveTo },
      { "EXCLUDECLIPRECT",      0x0415, &TQWinMetaFile::excludeClipRect },
      { "INTERSECTCLIPRECT",    0x0416, &TQWinMetaFile::intersectClipRect },
      { "ARC",                  0x0817, &TQWinMetaFile::arc },
      { "ELLIPSE",              0x0418, &TQWinMetaFile::ellipse },
      { "FLOODFILL",            0x0419, &TQWinMetaFile::noop },
      { "PIE",                  0x081A, &TQWinMetaFile::pie },
      { "RECTANGLE",            0x041B, &TQWinMetaFile::rectangle },
      { "ROUNDRECT",            0x061C, &TQWinMetaFile::roundRect },
      { "PATBLT",               0x061D, &TQWinMetaFile::noop },
      { "SAVEDC",               0x001E, &TQWinMetaFile::saveDC },
      { "SETPIXEL",             0x041F, &TQWinMetaFile::setPixel },
      { "OFFSETCLIPRGN",        0x0220, &TQWinMetaFile::noop },
      { "TEXTOUT",              0x0521, &TQWinMetaFile::textOut },
      { "BITBLT",               0x0922, &TQWinMetaFile::noop },
      { "STRETCHBLT",           0x0B23, &TQWinMetaFile::noop },
      { "POLYGON",              0x0324, &TQWinMetaFile::polygon },
      { "POLYLINE",             0x0325, &TQWinMetaFile::polyline },
      { "ESCAPE",               0x0626, &TQWinMetaFile::noop },
      { "RESTOREDC",            0x0127, &TQWinMetaFile::restoreDC },
      { "FILLREGION",           0x0228, &TQWinMetaFile::noop },
      { "FRAMEREGION",          0x0429, &TQWinMetaFile::noop },
      { "INVERTREGION",         0x012A, &TQWinMetaFile::noop },
      { "PAINTREGION",          0x012B, &TQWinMetaFile::noop },
      { "SELECTCLIPREGION",     0x012C, &TQWinMetaFile::noop },
      { "SELECTOBJECT",         0x012D, &TQWinMetaFile::selectObject },
      { "SETTEXTALIGN",         0x012E, &TQWinMetaFile::setTextAlign },
      { "CHORD",                0x0830, &TQWinMetaFile::chord },
      { "SETMAPPERFLAGS",       0x0231, &TQWinMetaFile::noop },
      { "EXTTEXTOUT",           0x0a32, &TQWinMetaFile::extTextOut },
      { "SETDIBTODEV",          0x0d33, &TQWinMetaFile::noop },
      { "SELECTPALETTE",        0x0234, &TQWinMetaFile::noop },
      { "REALIZEPALETTE",       0x0035, &TQWinMetaFile::noop },
      { "ANIMATEPALETTE",       0x0436, &TQWinMetaFile::noop },
      { "SETPALENTRIES",        0x0037, &TQWinMetaFile::noop },
      { "POLYPOLYGON",          0x0538, &TQWinMetaFile::polyPolygon },
      { "RESIZEPALETTE",        0x0139, &TQWinMetaFile::noop },
      { "DIBBITBLT",            0x0940, &TQWinMetaFile::dibBitBlt },
      { "DIBSTRETCHBLT",        0x0b41, &TQWinMetaFile::dibStretchBlt },
      { "DIBCREATEPATTERNBRUSH", 0x0142, &TQWinMetaFile::dibCreatePatternBrush },
      { "STRETCHDIB",           0x0f43, &TQWinMetaFile::stretchDib },
      { "EXTFLOODFILL",         0x0548, &TQWinMetaFile::noop },
      { "DELETEOBJECT",         0x01f0, &TQWinMetaFile::deleteObject },
      { "CREATEPALETTE",        0x00f7, &TQWinMetaFile::createEmptyObject },
      { "CREATEPATTERNBRUSH",   0x01F9, &TQWinMetaFile::createEmptyObject },
      { "CREATEPENINDIRECT",    0x02FA, &TQWinMetaFile::createPenIndirect },
      { "CREATEFONTINDIRECT",   0x02FB, &TQWinMetaFile::createFontIndirect },
      { "CREATEBRUSHINDIRECT",  0x02FC, &TQWinMetaFile::createBrushIndirect },
      { "CREATEREGION",         0x06FF, &TQWinMetaFile::createEmptyObject },
      { "END",                   0,      &TQWinMetaFile::end },
      // always the latest in the table : in case of unknown function
      { NULL,                   0,      &TQWinMetaFile::noop },
  };


#endif /*metafunc_h*/
