/*
    This file is part of KAddressBook.
    Copyright (c) 2004 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#include <tqlabel.h>
#include <tqlayout.h>

#include <kdialog.h>
#include <tdelocale.h>
#include <tdestandarddirs.h>

#include <libkcal/freebusyurlstore.h>

#include "freebusywidget.h"

FreeBusyWidget::FreeBusyWidget( TDEABC::AddressBook *ab, TQWidget *parent, const char *name )
  : KAB::ContactEditorWidget( ab, parent, name )
{
  TQHBoxLayout *layout = new TQHBoxLayout( this, KDialog::marginHint(),
                                         KDialog::spacingHint() );

  TQLabel *label = new TQLabel( i18n( "Location of Free/Busy information:" ), this );
  layout->addWidget( label );

  mURL = new KURLRequester( this );
  label->setBuddy( mURL );
  layout->addWidget( mURL );

  connect( mURL, TQ_SIGNAL( textChanged( const TQString& ) ),
           this, TQ_SLOT( setModified() ) );
}

FreeBusyWidget::~FreeBusyWidget()
{
}

void FreeBusyWidget::loadContact( TDEABC::Addressee *addr )
{
  if ( addr->preferredEmail().isEmpty() )
    return;

  mURL->setURL( KCal::FreeBusyUrlStore::self()->readUrl( addr->preferredEmail() ) );
}

void FreeBusyWidget::storeContact( TDEABC::Addressee *addr )
{
  if ( addr->preferredEmail().isEmpty() )
    return;

  KCal::FreeBusyUrlStore::self()->writeUrl( addr->preferredEmail(), mURL->url() );
  KCal::FreeBusyUrlStore::self()->sync();
  if ( mURL->url().isEmpty() ) {
    addr->removeCustom( "KADDRESSBOOK", "FreeBusyURL" );
  } else {
    addr->insertCustom( "KADDRESSBOOK", "FreeBusyURL", mURL->url() );
  }
}

void FreeBusyWidget::setReadOnly( bool readOnly )
{
  mURL->setEnabled( !readOnly );
}

#include "freebusywidget.moc"
