/*
    This file is part of Kandy.

    Copyright (c) 2001 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/
#ifndef KANDYVIEW_H
#define KANDYVIEW_H

#include <tqwidget.h>

class TQPainter;
class TQTextStream;
class TQDataStream;
class TQDomDocument;
class TQDomElement;
class TQTextEdit;
class TQListView;

class KURL;

class Modem;
class ATCommand;
class MobileGui;
class CommandScheduler;
class CmdPropertiesDialog;

/**
  This is the main view class for Kandy.
 
  @short Main view
  @author Cornelius Schumacher <schumacher@kde.org>
*/
class KandyView : public TQWidget
{
    TQ_OBJECT
  
  public:
	/**
	 * Default constructor
	 */
    KandyView(CommandScheduler *,TQWidget *parent);

	/**
	 * Destructor
	 */
    virtual ~KandyView();

    /**
      Import phonebook from mobile phone and save it to Kab. This function
      returns before the job is actually done.
    */
    void importPhonebook();

    /**
     * Print this view to any medium -- paper or not
     */
    void print(TQPainter *, int height, int width);

    bool loadFile(const TQString& filename);
    bool saveFile(const TQString& filename);

    void setModified(bool modified=true);
    bool isModified();

  public slots:
    void addCommand();
    void executeCommand();
    void deleteCommand();
    void editCommand();

  signals:
    /**
     * Use this signal to change the content of the statusbar
     */
    void signalChangeStatusbar(const TQString& text);

    /**
     * Use this signal to change the content of the caption
     */
    void signalChangeCaption(const TQString& text);

    void modifiedChanged(bool);

  protected slots:
    void appendOutput(const char *line);

    void setResult(ATCommand *);

  private slots:
    void slotSetTitle(const TQString& title);
    void processLastLine();

  private:
    TQString mLastInput;

    CommandScheduler *mScheduler;

    bool mModified;

    TQListView *mCommandList;

    TQTextEdit *mInput;
    TQTextEdit *mOutput;
    TQTextEdit *mResultView;
};

#endif // KANDYVIEW_H
