.TH KONSOLEKALENDAR 1
.SH NAME
konsolekalendar \- Command line interface to TDE calendars
.SH SYNOPSIS
.B konsolekalendar
.I [Qt-options] [TDE-options] [options]
.SH DESCRIPTION
.B KonsoleKalendar
is a command line interface to TDE calendars.  It lets you view, insert,
remove, or modify calendar events by way of the command line or from a
scripting language.  Additionally,
.B KonsoleKalendar
can create a new TDE calendar, export a TDE calendar to a variety of other
formats, and import another TDE calendar.
.SH PROGRAM OPTIONS
.TP
.B --verbose
Print helpful runtime messages.
.TP
.B --dry-run
Print what would have been done, but do not execute
.TP
.B --file \fI<calendar-file>\fB
Specify which calendar you want to use.
.LP

Major operation modes:
.TP
.B --view
Print calendar events in specified export format.
.TP
.B --add
Insert an event into the calendar.
.TP
.B --change
Modify an existing calendar event.
.TP
.B --delete
Remove an existing calendar event.
.TP
.B --create
Create new calendar file if one does not exist.
.TP
.B --import \fI<import-file>\fB
Import this calendar to main calendar.
.LP

Operation modifiers:
.TP
.B --all
View all calendar entries
.TP
.B --next
View next activity in calendar.
.TP
.B --show-next \fI<days>\fB
From start date show next # days' activities.
.TP
.B --uid \fI<uid>\fB
Event Unique-string identifier.
.TP
.B --date \fI<start-date>\fB
Start from this day [YYYY-MM-DD].
.TP
.B --time \fI<start-time>\fB
Start from this time [HH:MM:SS].
.TP
.B --end-date \fI<end-date>\fB
End at this day [YYYY-MM-DD].
.TP
.B --end-time \fI<end-time>\fB
End at this time [HH:MM:SS].
.TP
.B --epoch-start \fI<epoch-time>\fB
Start from this time [secs since epoch].
.TP
.B --epoch-end \fI<epoch-time>\fB
End at this time [secs since epoch].
.TP
.B --summary \fI<summary>\fB
Add summary to event (for add/change modes).
.TP
.B --description \fI<description>\fB
Add description to event (for add/change modes).
.TP
.B --location \fI<location>\fB
Add location to event (for add/change modes).
.LP

Export options:
.TP
.B --export-type \fI<export-type>\fB
Export file type (Default: text).
.TP
.B --export-file \fI<export-file>\fB
Export to file (Default: stdout).
.TP
.B --export-list
Print list of export types supported and exit.
.so kdeopt.part
.SH EXAMPLES
konsolekalendar --view

konsolekalendar --add --date 2003-06-04 --time 10:00 --end-time 12:00
--summary "Doctor Visit" --description "Get My Head Examined"

konsolekalendar --delete --uid KOrganizer-1740326.803
.SH SEE ALSO
More detailed user documentation is available from
.BR help:/konsolekalendar
(either enter this URL into \fBkonqueror\fP, or run `khelpcenter
help:/konsolekalendar').
