#ifndef PAINTER_H
#define PAINTER_H

#include <tdeapplication.h>

#include <tdelocale.h>
#include <tqpixmap.h>
#include <tqbitmap.h>
#include <tqlabel.h>
#include <tqcolor.h>
#include <tqptrlist.h>
#include <tqstrlist.h>
#include <tqregexp.h>

#include "board.h"
#include "bitfont.h"
#include "colors.h"

enum PixMap { PacmanPix, DyingPix, MonsterPix, EyesPix, FruitPix,
              PointPix, EnergizerPix, WallPix, PrisonPix,
              FruitScorePix, MonsterScorePix };
enum DrawWidget { Widget, RoomPix, BackPix };

class Painter
{
public:
    Painter (Board *, TQWidget *parent=0, int scheme=-1, int mode=-1,Bitfont *font=0);
    TQPixmap levelPix() { return roomPix; }

    void setScheme(int scheme=-1, int mode=-1, Bitfont *font=0);
    void setLevel(int level=0);

    TQRect rect(int pos, PixMap pix, uint i = 0);
    TQRect rect(int pos, TQString str, int align = TQLabel::AlignCenter );
    TQRect rect(TQRect r1, TQRect r2);

    void draw(TQPoint point, DrawWidget where, TQPixmap pix);
    void draw(TQRect rect, DrawWidget where, TQPixmap pix);
    void draw(int pos, DrawWidget where, PixMap pix, uint i = 0);
    TQPixmap draw(int pos, DrawWidget where, TQString str,
                 TQColor fg, TQColor bg = TQColor(), int align = TQLabel::AlignCenter);
    TQRect draw(int col, int row, DrawWidget where, TQString str,
               TQColor fg, TQColor bg = TQColor(), int align = TQLabel::AlignCenter);

    void drawBrick(int pos);
    void drawPrison(int pos);
    void drawPoint(int pos);

    void erase(int pos, PixMap pix, uint i = 0);

    int maxPixmaps(PixMap pix);

protected:
    TQString decodeHexOctString(TQString str);

    void fillScoreString(TQStrList &, TQMemArray<int> &);
    void fillArray(TQMemArray<int> &, TQString, int);
    void fillStrList(TQStrList &, TQString, int);
    void fillPixmapName(TQStrList &);

    void confScheme();
    void confLevels(bool defGroup=true);
    void confMisc(bool defGroup=true);
    void confScoring(bool defGroup=true);

    void initPixmaps();
    void initRoomPixmap();
    void initbackPixmaps();

private:
    TQWidget *w;
    Board *board;
    Bitfont *bitfont;

    int BlockWidth;
    int BlockHeight;

    TQMemArray<int> fruitScore;
    TQStrList fruitScoreString;
    TQMemArray<int> monsterScore;
    TQStrList monsterScoreString;

    TQString pixmapDirectory;

    TQStrList pointPixmapName;
    TQStrList wallPixmapName;
    TQStrList prisonPixmapName;
    TQStrList energizerPixmapName;
    TQStrList fruitPixmapName;
    TQStrList pacmanPixmapName;
    TQStrList dyingPixmapName;
    TQStrList eyesPixmapName;
    TQStrList monsterPixmapName;
    TQStrList fruitScorePixmapName;
    TQStrList monsterScorePixmapName;

    TQString lastPointPixmapName;
    TQString lastWallPixmapName;
    TQString lastPrisonPixmapName;
    TQString lastEnergizerPixmapName;
    TQString lastFruitPixmapName;
    TQString lastPacmanPixmapName;
    TQString lastDyingPixmapName;
    TQString lastEyesPixmapName;
    TQString lastMonsterPixmapName;
    TQString lastFruitScorePixmapName;
    TQString lastMonsterScorePixmapName;

    TQPtrList<TQPixmap> *loadPixmap(TQWidget *parent, TQString pixmapName,
                               TQPtrList<TQPixmap> *pixmaps=0);
	TQPtrList<TQPixmap> *textPixmap(TQStrList &, TQPtrList<TQPixmap> *pixmaps=0,
                               TQColor fg = BLACK, TQColor bg = TQColor());
	TQPtrList<TQPixmap> *textPixmap(TQString str, TQPtrList<TQPixmap> *pixmaps=0,
                               TQColor fg = BLACK, TQColor bg = TQColor());

    TQPoint point(int pos);
    int checkRange(int value, int max, int min=0);

    TQPtrList<TQPixmap> *wallPix;
    TQPtrList<TQPixmap> *prisonPix;
    TQPtrList<TQPixmap> *pointPix;
    TQPtrList<TQPixmap> *energizerPix;
    TQPtrList<TQPixmap> *fruitPix;
    TQPtrList<TQPixmap> *pacmanPix;
    TQPtrList<TQPixmap> *dyingPix;
    TQPtrList<TQPixmap> *eyesPix;
    TQPtrList<TQPixmap> *monsterPix;
    TQPtrList<TQPixmap> *fruitScorePix;
    TQPtrList<TQPixmap> *monsterScorePix;

    TQPixmap roomPix;
    TQPixmap backPix;

    bool plainColor;
    TQColor backgroundColor;

    int maxLevel;
    int level;

    int scheme;
    int mode;
};

#endif // PAINTER_H
