/***************************************************************************
 *
 * tdenetman.h - A NetworkManager frontend for TDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa    <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef VPN_TRAY_COMPONENT_H
#define VPN_TRAY_COMPONENT_H

// TDE includes
#include <tdehardwaredevices.h>
#include <tdenetworkconnections.h>

// TDENM includes
#include "traycomponent.h"

#include "tdenetman.h"

class VPNTrayComponent : public TrayComponent
{
	TQ_OBJECT
  

	public:
		VPNTrayComponent (KSystemTray * parent = 0, const char * name = 0);
		~VPNTrayComponent ();

		void addMenuItems(TDEPopupMenu* menu);

	public slots:
		void slotShowNewConnectionDialog();

	private slots:
		void vpnEventHandler(TDENetworkVPNEventType::TDENetworkVPNEventType event, TQString message);

	private:
};

#endif /* VPN_TRAY_COMPONENT_H */
