/***************************************************************************
                                invitation.h
                             -------------------
    begin                : Sat Mar 30 2002
    copyright            : (C) 2002 by Tim Jansen
    email                : tim@tjansen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INVITATION_H
#define INVITATION_H

#include <tdeapplication.h>
#include <tdelistview.h>
#include <tdeconfig.h>
#include <tqobject.h>
#include <tqstring.h>
#include <tqdatetime.h>


const int INVITATION_DURATION = 60*60;

TQString cryptStr(const TQString &aStr);

class Invitation {
public:
	Invitation();
	~Invitation();
	Invitation(TDEConfig* config, int num);
	Invitation(const Invitation &x);
	Invitation &operator= (const Invitation&x);

	TQString password() const;
	TQDateTime expirationTime() const;
	TQDateTime creationTime() const;
	bool isValid() const;

	void setViewItem(TDEListViewItem*);
	TDEListViewItem* getViewItem() const;
	void save(TDEConfig *config, int num) const;
private:
	TQString m_password;
	TQDateTime m_creationTime;
	TQDateTime m_expirationTime;

	TDEListViewItem *m_viewItem;
};

#endif
