/***************************************************************************
                          highlightpreferences.h  -  description
                             -------------------
    begin                : mar 14 2003
    copyright            : (C) 2003 by Olivier Goffart
    email                : ogoffart @ kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef HighlightPREFERENCES_H
#define HighlightPREFERENCES_H

#include <tdecmodule.h>
#include <tqstring.h>

class HighlightPrefsUI;
class Filter;
class TQListViewItem;

/**
  *@author Olivier Goffart
  */

class HighlightPreferences : public TDECModule  {
   TQ_OBJECT
  
public:

	HighlightPreferences(TQWidget *parent = 0, const char* name = 0, const TQStringList &args = TQStringList());
	~HighlightPreferences();

	virtual void save();
	virtual void load();

private:
	HighlightPrefsUI *preferencesDialog;
	HighlightConfig *m_config;
	TQMap <TQListViewItem*,Filter*> m_filterItems;

	bool donttouch;

private slots:
	void slotCurrentFilterChanged();
	void slotAddFilter();
	void slotRemoveFilter();
	void slotRenameFilter();
	void slotSomethingHasChanged();
	void slotEditRegExp();
};

#endif
