#include "mimetypetree.h"
#include <kmimetype.h>
#include <tqdict.h>
#include <tqheader.h>


MimeTypeTree::MimeTypeTree(TQWidget *parent)
	: TDEListView(parent)
{
	KMimeType::List list=KMimeType::allMimeTypes();
	TQDict<TQListViewItem> map;
	setRootIsDecorated(true);

	addColumn("-");
	header()->hide();
    TQValueListIterator<KMimeType::Ptr> i(list.begin());
	for (; i != list.end(); ++i)
	{
		TQString mimetype = (*i)->name();
		int slash = mimetype.find("/");
		TQString major = mimetype.left(slash);
		
		// hide all and inode majors
		if (major == "all" || major=="inode")
			continue;

		TQString minor = mimetype.mid(slash+1);
		TQListViewItem *majorItem=map[major];
		if (!majorItem)
		{
			majorItem=addMajor(major);
			map.insert(major, majorItem);
		}
		
		new TQListViewItem(majorItem, minor);
	}
}

void MimeTypeTree::sel(TQListViewItem *item)
{
	TQListViewItem *p=item->parent();
	if (!p) return;
	TQString major=p->text(0);
	TQString minor=item->text(0);
	
	emit selected(major+'/'+minor);
}

TQListViewItem* MimeTypeTree::addMajor(const TQString &name)
{
	return new TQListViewItem(this, name);
}


// GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666
// 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 
// GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666
// 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 
// GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666
// 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 
// GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666
// 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 666 GPL 

#include "mimetypetree.moc"
