/***************************************************************************
	helpers.cpp
	Just a few functions needed in several Kjofol-classes
	---------------------------------------------
	Maintainer: Charles Samuels <charles@kde.org>

 ***************************************************************************/

#ifndef KJHELPERS_CPP
#define KJHELPERS_CPP

static int grayRgb(TQRgb r)
{
	return tqGray(tqRed(r), tqGreen(r), tqBlue(r));
}

static int isGray(TQRgb r)
{
// this is more tolerant than the old version
// i.e. RGB 162 163 162 is treated as gray too
// too many broken skins around having such colors

//	cerr << "r("<<tqRed(r)<<","<<tqGreen(r)<<","<<tqBlue(r)<<")"<<endl;

	if ( (tqRed(r)==tqGreen(r)) || (tqRed(r)+1==tqGreen(r)) || (tqRed(r)-1==tqGreen(r)))
	{
		if ( (tqRed(r)==tqBlue(r)) || (tqRed(r)+1==tqBlue(r)) || (tqRed(r)-1==tqBlue(r)))
		{
			// looks a bit like gray, so return true
			return (1);
		}
	}
	// well, it's not gray
	return(0);

/*
	// mETz: wrong braces in the code below ??
	return (tqRed(r)==tqGreen(r)) && (tqRed(r) == tqBlue(r));
*/
}

// only works little endian
// UPDATE: should work on both little and big endian now (haven't tested that!)
// this code is taken from the QT-docu and I hope that this example
// is one of the working ones ;)
inline void setPixel1BPP(TQImage &image, int x, int y, bool value)
{
	if ( image.bitOrder() == TQImage::LittleEndian )
	{
		if (value)
			*(image.scanLine(y) + (x >> 3)) |= 1 << (x & 7);
		else
			*(image.scanLine(y) + (x >> 3)) &= ~(1 << (x & 7));
	}
	else
	{
		if (value)
			*(image.scanLine(y) + (x >> 3)) |= 1 << (7-(x & 7));
		else
			*(image.scanLine(y) + (x >> 3)) &= ~(1 << (7-(x & 7)));
	}
}

#endif
